define([
    'jquery',
    "domReady!",
    'jquery/ui'
], function($){
    "use strict";

    function main(config) {
        $(document).ready( function(){
            $(config.target).keyup(function(){
                // Retrieve the input field text and reset the count to zero
                let filter = $(this).val(), count = 0;
                // Loop through the comment list
                $("#swatch-opt-"+config.productId+" > div.swatch-attribute.tartan > div.swatch-attribute-options > div.option-paragraph > div.swatchlabel-paragraph").each(function(){
                    // If the list item does not contain the text phrase fade it out
                    if ($(this).text().search(new RegExp(filter, "i")) < 0) {
                        $(this).parent().fadeOut();
                        // Show the list item if the phrase matches and increase the count by 1
                    } else {
                        $(this).parent().show();
                        count++;
                    }
                });
                // Update the count
                if(count < 1) {
                    $("#no-count-"+config.productId).text('No result');
                } else {
                    $("#no-count-"+config.productId).text('');
                }
            });
        });
    }
    return main;
});
