<?php
namespace Mtc\Finder\Plugin;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Filesystem\Directory\WriteInterface;
use Magento\Framework\Serialize\Serializer\Json;
use Magento\Swatches\Block\Product\Renderer\Configurable;
use Magento\Catalog\Api\ProductAttributeRepositoryInterface;
use Magento\Swatches\Helper\Data;
use Magento\Framework\Filesystem\Io\File;
use Magento\Swatches\Helper\Media;
use Magento\Framework\Filesystem;
use Magento\Framework\Filesystem\Driver\File as FileDriver;
use Magento\Store\Model\StoreManagerInterface;
use Psr\Log\LoggerInterface;

class AddTartanColorImage
{

    /**
     * @var Json
     */
    private $jsonEncoder;

    /**
     * @var Data
     */
    private $swatchHelper;

    /**
     * @var ProductAttributeRepositoryInterface
     */
    private $productAttributeRepository;

    /**
     * @var File
     */
    private $file;

    /**
     * @var Media
     */
    private $swatchMedia;

    /**
     * @var WriteInterface
     */
    private $mediaDirectory;

    /**
     * @var FileDriver
     */
    private $fileDriver;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @param Json $jsonEncoder
     * @param ProductAttributeRepositoryInterface $productAttributeRepository
     * @param Data $swatchHelper
     * @param File $file
     * @param Media $swatchMedia
     * @param Filesystem $filesystem
     * @param FileDriver $fileDriver
     * @param StoreManagerInterface $storeManager
     * @param LoggerInterface $logger
     * @throws FileSystemException
     */
    public function __construct(
        Json $jsonEncoder,
        ProductAttributeRepositoryInterface $productAttributeRepository,
        Data $swatchHelper,
        File $file,
        Media $swatchMedia,
        Filesystem $filesystem,
        FileDriver $fileDriver,
        StoreManagerInterface $storeManager,
        LoggerInterface $logger
    ) {
        $this->jsonEncoder = $jsonEncoder;
        $this->productAttributeRepository = $productAttributeRepository;
        $this->swatchHelper = $swatchHelper;
        $this->file = $file;
        $this->swatchMedia = $swatchMedia;
        $this->mediaDirectory = $filesystem->getDirectoryWrite(DirectoryList::MEDIA);
        $this->fileDriver = $fileDriver;
        $this->storeManager = $storeManager;
        $this->logger = $logger;
    }

    /**
     * @param Configurable $subject
     * @param $result
     * @return bool|string
     */
    public function afterGetJsonSwatchConfig(Configurable $subject, $result)
    {
        $result = $this->jsonEncoder->unserialize($result);
        $tartanAttributeId = null;
        $tartan = null;
        $colour = null;
        try {
            $tartan = $this->productAttributeRepository->get('tartan');
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
        }
        if ($tartan) {
            $tartanAttributeId = $tartan->getAttributeId();
            try {
                $colour = $this->productAttributeRepository->get('colour');
            } catch (\Exception $e) {
                $this->logger->critical($e->getMessage());
            }
            if ($colour) {
                $options = $colour->getOptions();
                if ($tartanAttributeId) {
                    foreach ($result as $attribute => $attributeData) {
                        if ($attribute == $tartanAttributeId) {
                            foreach ($attributeData as $key => $value) {
                                $colorsImages = [];
                                if (is_numeric($key)) {
                                    foreach ($options as $option) {
                                        if ($option->getData('value')) {
                                            $path = null;
                                            try {
                                                $imgValue = $this->swatchHelper->getSwatchesByOptionsId([$key]);
                                            } catch (\Exception $e) {
                                                $this->logger->critical($e->getMessage());
                                            }
                                            if ($option['label'] == 'Ancient') {
                                                try {
                                                    $path = $this->getTartanColorPath($imgValue, $key, 'a');
                                                } catch (\Exception $e) {
                                                    $this->logger->critical($e->getMessage());
                                                }
                                                if ($path) {
                                                    $colorsImages[$option->getData('value')] = $path;
                                                }
                                            }
                                            if ($option['label'] == 'Muted') {
                                                try {
                                                    $path = $this->getTartanColorPath($imgValue, $key, 'm');
                                                } catch (\Exception $e) {
                                                    $this->logger->critical($e->getMessage());
                                                }
                                                if ($path) {
                                                    $colorsImages[$option->getData('value')] = $path;
                                                }
                                            }
                                            if ($option['label'] == 'Weathered') {
                                                try {
                                                    $path = $this->getTartanColorPath($imgValue, $key, 'w');
                                                } catch (\Exception $e) {
                                                    $this->logger->critical($e->getMessage());
                                                }
                                                if ($path) {
                                                    $colorsImages[$option->getData('value')] = $path;
                                                }
                                            }
                                        }
                                    }
                                    $result[$attribute][$key]['colors'] = $colorsImages;
                                }
                            }
                        }
                    }
                }
            }
        }
        return $this->jsonEncoder->serialize($result);
    }

    /**
     * @param $imgValue
     * @param $key
     * @param $color
     * @return string
     * @throws FileSystemException
     * @throws NoSuchEntityException
     */
    private function getTartanColorPath($imgValue, $key, $color) {
        $pathInfo = $this->file->getPathInfo($imgValue[$key]['value']);
        $filename = $pathInfo['filename'];
        $filename = $filename.$color.'.';
        $tartanPath = $pathInfo['dirname'].'/'.$filename.$pathInfo['extension'];
        $mediaPath = $this->swatchMedia->getSwatchMediaPath().$tartanPath;
        $colorImgPath = $this->mediaDirectory
            ->getAbsolutePath($this->swatchMedia->getSwatchMediaPath(). $tartanPath);
        if ($this->fileDriver->isExists($colorImgPath)) {
            $mediaUrl = $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
            return $mediaUrl.$mediaPath;
        }
        return '';
    }
}
