<?php
namespace Mtc\Finder\Plugin;

use Magento\ConfigurableProduct\Block\Product\View\Type\Configurable;
use Magento\Framework\App\Request\Http;

class AddTartanClanFilter
{

    private $request;

    public function __construct(
        Http $request
    ) {
        $this->request = $request;
    }

    public function afterGetAllowProducts(Configurable $subject, $result)
    {
        if ($this->request->getParam('tartan')) {
            $products = [];
            foreach ($result as $product) {
                $tartanId = $product->getTartanId();
                $categoryIds = $product->getCategoryIds();
                $categoryId = $this->request->getParam('catId');
                if ($tartanId && $tartanId == $this->request->getParam('tartan')) {
                    $products[] = $product;
                }
                if ($categoryId && in_array($categoryId, $categoryIds)) {
                    $products[] = $product;
                }
            }
            $subject->setAllowProducts($products);
            return $subject->getData('allow_products');
        }
        if ($this->request->getParam('clan')) {
            $products = [];
            foreach ($result as $product) {
                $clanId = $product->getClanId();
                $categoryIds = $product->getCategoryIds();
                $categoryId = $this->request->getParam('catId');
                if ($clanId && $clanId == $this->request->getParam('clan')) {
                    $products[] = $product;
                }
                if ($categoryId && in_array($categoryId, $categoryIds)) {
                    $products[] = $product;
                }
            }
            $subject->setAllowProducts($products);
            return $subject->getData('allow_products');
        }
        return $result;
    }
}
