<?php
namespace Mtc\Finder\Api\Data;

/**
 * interface TartanManagerInterface
 * @api
 */
interface TartanManagerInterface
{
    const TARTAN_ID = 'tartan_id';

    const CATEGORY_ID = 'category_id';

    const NAME = 'name';

    const TARTAN_IMAGE = 'tartan_image';

    const CAN_BUY = 'can_buy';

    const CREATED_AT = 'created_at';

    const UPDATED_AT = 'updated_at';

    const REF_PIC = 'ref_pic';

    const FAMILY = 'family';

    const SORT_ORDER = 'sort_order';

    const CLASSIFICATION = 'classification';

    const ENTITY_ID = 'entity_id';

    const COLOUR_ID = 'colour_id';

    const SUPPLIER = 'supplier';

    const WEIGHT = 'weight';

    const COLLECTION = 'collection';

    const MAN_REF = 'man_ref';

    const HOT_PRODUCT_CODE = 'hot_product_code';

    const NOTES = 'notes';
    
    const DUPLICATE_LIST = 'duplicate_lists';

    const COPY = 'copy';

    const PARTNER = 'partner';

    const COLOURS = 'colours';

    /**
     * @param string $tartanId
     * @return $this
     */
    public function setTartanId($tartanId);

    /**
     * @return string
     */
    public function getTartanId();

    /**
     * @param string $categoryId
     * @return $this
     */
    public function setCategoryId($categoryId);

    /**
     * @return string
     */
    public function getCategoryId();

    /**
     * @param string $name
     * @return $this
     */
    public function setName($name);

    /**
     * @return string
     */
    public function getName();

    /**
     * Set Tartan Image
     *
     * @param $tartanImage
     * @return TartanManagerInterface
     */

    public function setTartanImage($tartanImage);

    /**
     * Get Tartan Image
     *
     * @return string
     */
    public function getTartanImage();

    /**
     * Get Tartan Image
     *
     * @return string
     */
    public function getTartanImageURL();

    /**
     * @param string $canBuy
     * @return $this
     */
    public function setCanBuy(string $canBuy);

    /**
     * @return string
     */
    public function getCanBuy();

    /**
     * @param string $createdAt
     * @return $this
     */
    public function setCreatedAt($createdAt);

    /**
     * @return string
     */
    public function getCreatedAt();

    /**
     * @param string $updatedAt
     * @return $this
     */
    public function setUpdatedAt($updatedAt);

    /**
     * @return string
     */
    public function getUpdatedAt();


    /**
     * @param string $refPic
     * @return $this
     */
    public function setRefPic($refPic);

    /**
     * @return string
     */
    public function getRefPic();

    /**
     * @param string $family
     * @return $this
     */
    public function setFamily($family);

    /**
     * @return string
     */
    public function getFamily();
    
    /**
     * @param string $duplicateLists
     * @return $this
     */
    public function setDuplicateLists($duplicateLists);

    /**
     * @return string
     */
    public function getDuplicateLists();

    /**
     * @param string $copy
     * @return $this
     */
    public function setCopy($copy);

    /**
     * @return string
     */
    public function getCopy();

    /**
     * @param string $partner
     * @return $this
     */
    public function setPartner($partner);

    /**
     * @return string
     */
    public function getPartner();

    /**
     * @param string $colours
     * @return $this
     */
    public function setColours($colours);

    /**
     * @return string
     */
    public function getColours();

    
    /**
     * @param string $sortOrder
     * @return $this
     */
    public function setSortOrder($sortOrder);

    /**
     * @return string
     */
    public function getSortOrder();

    /**
     * @param string $classification
     * @return $this
     */
    public function setClassification($classification);

    /**
     * @return string
     */
    public function getClassification();

    /**
     * @param int $entityId
     * @return $this
     */
    public function setEntityId($entityId);

    /**
     * @return int
     */
    public function getEntityId();

    /**
     * @param string $colourId
     * @return $this
     */
    public function setColourId($colourId);

    /**
     * @return string
     */
    public function getColourId();

    /**
     * @param string $supplier
     * @return $this
     */
    public function setSupplier($supplier);

    /**
     * @return string
     */
    public function getSupplier();

    /**
     * @param string $weight
     * @return $this
     */
    public function setWeight($weight);

    /**
     * @return string
     */
    public function getWeight();

    /**
     * @param string $collection
     * @return $this
     */
    public function setCollection($collection);

    /**
     * @return string
     */
    public function getCollection();

    /**
     * @param string $manuRef
     * @return $this
     */
    public function setManRef($manuRef);

    /**
     * @return string
     */
    public function getManRef();

    /**
     * @param string $hotProductCode
     * @return $this
     */
    public function setHotProductCode($hotProductCode);

    /**
     * @return string
     */
    public function getHotProductCode();

    /**
     * @param string $notes
     * @return $this
     */
    public function setNotes($notes);

    /**
     * @return string
     */
    public function getNotes();
}
