define([
    'jquery',
    'underscore',
    'jquery/ui',
    'jquery/jquery.parsequery',
    'mage/translate'
], function ($, _) {
    'use strict';
    return function (widget) {

        $.widget('mage.SwatchRenderer', widget, {

            /**
             * Input for submit form.
             * This control shouldn't have "type=hidden", "display: none" for validation work :(
             *
             * @param {Object} config
             * @private
             */
            _RenderFormInput: function (config) {
                let msgTxt = $.mage.__("Please select tartan and colour.");
                if (this.options.fieldDisabled) {
                    return '<input class="' + this.options.classes.attributeInput + ' super-attribute-select" ' +
                        'name="super_attribute[' + this.options.jsonConfig.productId + '][' + config.id + ']" ' +
                        'type="text" ' +
                        'value="" ' +
                        'data-selector="super_attribute[' + config.id + ']" ' +
                        'data-validate="{required: true}" ' +
                        'aria-required="true" ' +
                        'aria-invalid="false" ' +
                        'data-errors-message-box="#tartan-errors-'+this.options.jsonConfig.productId+'" ' +
                        'data-msg-required="' + msgTxt + '" ' +
                        'disabled="disabled">';
                } else {
                    return '<input class="' + this.options.classes.attributeInput + ' super-attribute-select" ' +
                        'name="super_attribute[' + this.options.jsonConfig.productId + '][' + config.id + ']" ' +
                        'type="text" ' +
                        'value="" ' +
                        'data-selector="super_attribute[' + config.id + ']" ' +
                        'data-validate="{required: true}" ' +
                        'aria-required="true" ' +
                        'aria-invalid="false" ' +
                        'data-errors-message-box="#tartan-errors-'+this.options.jsonConfig.productId+'" ' +
                        'data-msg-required="' + msgTxt + '">';
                }
            },
                    /**
             * Render swatch options by part of config
             *
             * @param {Object} config
             * @param {String} controlId
             * @returns {String}
             * @private
             */
            _RenderSwatchOptions: function (config, controlId) {
                var optionConfig = this.options.jsonSwatchConfig[config.id],
                    optionClass = this.options.classes.optionClass,
                    sizeConfig = this.options.jsonSwatchImageSizeConfig,
                    moreLimit = parseInt(this.options.numberToShow, 10),
                    moreClass = this.options.classes.moreButton,
                    moreText = this.options.moreButtonText,
                    countAttributes = 0,
                    html = '';

                if (!this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {
                    return '';
                }

                $.each(config.options, function (index) {
                    var id,
                        type,
                        value,
                        thumb,
                        label,
                        width,
                        height,
                        attr,
                        swatchImageWidth,
                        swatchImageHeight;

                    if (!optionConfig.hasOwnProperty(this.id)) {
                        return '';
                    }

                    // Add more button
                    if (moreLimit === countAttributes++) {
                        html += '<a href="#" class="' + moreClass + '"><span>' + moreText + '</span></a>';
                    }

                    id = this.id;
                    type = parseInt(optionConfig[id].type, 10);
                    value = optionConfig[id].hasOwnProperty('value') ?
                        $('<i></i>').text(optionConfig[id].value).html() : '';
                    thumb = optionConfig[id].hasOwnProperty('thumb') ? optionConfig[id].thumb : '';
                    width = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.width : 110;
                    height = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.height : 90;
                    label = this.label ? $('<i></i>').text(this.label).html() : '';
                    attr =
                        ' id="' + controlId + '-item-' + id + '"' +
                        ' index="' + index + '"' +
                        ' aria-checked="false"' +
                        ' aria-describedby="' + controlId + '"' +
                        ' tabindex="0"' +
                        ' data-option-type="' + type + '"' +
                        ' data-option-id="' + id + '"' +
                        ' data-option-label="' + label + '"' +
                        ' aria-label="' + label + '"' +
                        ' role="option"' +
                        ' data-thumb-width="' + width + '"' +
                        ' data-thumb-height="' + height + '"';

                    attr += thumb !== '' ? ' data-option-tooltip-thumb="' + thumb + '"' : '';
                    attr += value !== '' ? ' data-option-tooltip-value="' + value + '"' : '';

                    swatchImageWidth = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.width : 30;
                    swatchImageHeight = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.height : 20;

                    if (!this.hasOwnProperty('products') || this.products.length <= 0) {
                        attr += ' data-option-empty="true"';
                    }

                    if (type === 0) {
                        // Text
                        html += '<div class="' + optionClass + ' text" ' + attr + '>' + (value ? value : label) +
                            '</div>';
                    } else if (type === 1) {
                        // Color
                        html += '<div class="' + optionClass + ' color" ' + attr +
                            ' style="background: ' + value +
                            ' no-repeat center; background-size: initial;">' + '' +
                            '</div>';
                    } else if (type === 2) {
                        // Image
                        html += '<div class="option-paragraph"><div class="' + optionClass + ' image" ' + attr +
                            ' style="background: url(' + value + ') no-repeat center; background-size: initial;width:' +
                            swatchImageWidth + 'px; height:' + swatchImageHeight + 'px">' + '' +
                            '</div><div class="swatchlabel-paragraph">'+label+'</div></div>';
                    } else if (type === 3) {
                        // Clear
                        html += '<div class="' + optionClass + '" ' + attr + '></div>';
                    } else {
                        // Default
                        html += '<div class="' + optionClass + '" ' + attr + '>' + label + '</div>';
                    }
                });

                return html;
            },
            /**
             * Event for swatch options
             *
             * @param {Object} $this
             * @param {Object} $widget
             * @private
             */
            _OnClick: function ($this, $widget) {
                $widget._super($this, $widget);
                let tartanOptionId;
                let tartanAttributeId;
                let tartanAttributeCode;
                let colorAttributeId;
                let tartanThumb;
                let imgElem;
                let tartanTitle;
                let htmlStr = "";
                let colorId;
                tartanOptionId = $this.data('option-id');
                $this.parent().find('.swatchlabel-paragraph').addClass('selected');
                tartanAttributeId = $this.parents('.' + $widget.options.classes.attributeClass).data('attribute-id');
                tartanAttributeCode = $this.parents('.' + $widget.options.classes.attributeClass).data('attribute-code');
                if (tartanAttributeCode === 'tartan') {
                    if ($this.hasClass('selected')) {
                        tartanThumb = this.options.jsonSwatchConfig[tartanAttributeId][tartanOptionId]['thumb'];
                        tartanTitle = this.options.jsonSwatchConfig[tartanAttributeId][tartanOptionId]['label'];
                        colorAttributeId = $this.parent().parent().prev().data('attribute-id');
                        colorId = $('input[name="super_attribute['+this.options.jsonConfig.productId+']['+colorAttributeId+']"]').val();
                        if (this.options.jsonSwatchConfig[tartanAttributeId][tartanOptionId].colors[colorId] !== undefined) {
                            tartanThumb = this.options.jsonSwatchConfig[tartanAttributeId][tartanOptionId].colors[colorId];
                        }
                        imgElem = '<img src="'+tartanThumb+'"  alt="'+tartanAttributeCode+'">';
                        htmlStr = imgElem + '<span class="tartan-title">'+tartanTitle+'</span>';
                        $('#selected-tartan-'+this.options.jsonConfig.productId).html(htmlStr);

                    } else {
                        $('#select-tartan').html('Select Tartan');
                    }
                }
                if (tartanAttributeCode === 'colour') {
                    if ($this.hasClass('selected')) {
                        tartanAttributeId = $this.parent().parent().next().data('attribute-id');
                        tartanOptionId = $('input[name="super_attribute['+this.options.jsonConfig.productId+']['+tartanAttributeId+']"]').val();
                        if (tartanAttributeId && tartanOptionId) {
                            tartanThumb = this.options.jsonSwatchConfig[tartanAttributeId][tartanOptionId]['thumb'];
                            tartanTitle = this.options.jsonSwatchConfig[tartanAttributeId][tartanOptionId]['label'];
                            colorId = $this.data('option-id');
                            if (this.options.jsonSwatchConfig[tartanAttributeId][tartanOptionId].colors[colorId] !== undefined) {
                                tartanThumb = this.options.jsonSwatchConfig[tartanAttributeId][tartanOptionId].colors[colorId];
                            }
                            imgElem = '<img src="'+tartanThumb+'"  alt="'+tartanAttributeCode+'">';
                            htmlStr = imgElem + '<span class="tartan-title">'+tartanTitle+'</span>';
                            $('#selected-tartan-'+this.options.jsonConfig.productId).html(htmlStr);
                        }
                    } else {
                        $('#select-tartan').html('Select Tartan');
                    }
                }
            }
        });

        return $.mage.SwatchRenderer;
    }
});
