<?php
namespace Mtc\Finder\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\ConfigurableProduct\Model\Product\Type\Configurable;
use Magento\Store\Model\StoreManagerInterface;
use Psr\Log\LoggerInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Eav\Model\Config;
use Mtc\Finder\Api\TartanManagerRepositoryInterface;
use Magento\Catalog\Model\CategoryRepository;
use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\App\Response\RedirectInterface;
use Magento\Catalog\Model\ProductFactory;

class RestrictedTartan implements ObserverInterface
{
    /**
     * @var Configurable
     */
    private $configurable;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @var Config
     */
    private $eavConfig;

    /**
     * @var TartanManagerRepositoryInterface
     */
    private $tartanManagerRepository;

    /**
     * @var CategoryRepository
     */
    private $categoryRepository;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var ManagerInterface
     */
    private $messageManager;

    /**
     * @var RedirectInterface
     */
    private $redirect;

    /**
     * @var ProductFactory
     */
    private $productloader;

    /**
     * @param Configurable $configurable
     * @param LoggerInterface $logger
     * @param RequestInterface $request
     * @param Config $eavConfig
     * @param TartanManagerRepositoryInterface $tartanManagerRepository
     * @param CategoryRepository $categoryRepository
     * @param StoreManagerInterface $storeManager
     * @param ManagerInterface $messageManager
     * @param RedirectInterface $redirect
     * @param ProductFactory $productloader
     */
    public function __construct(
        Configurable $configurable,
        LoggerInterface $logger,
        RequestInterface $request,
        Config $eavConfig,
        TartanManagerRepositoryInterface $tartanManagerRepository,
        CategoryRepository $categoryRepository,
        StoreManagerInterface $storeManager,
        ManagerInterface $messageManager,
        RedirectInterface $redirect,
        ProductFactory $productloader
    ) {
        $this->configurable = $configurable;
        $this->logger = $logger;
        $this->request = $request;
        $this->eavConfig = $eavConfig;
        $this->tartanManagerRepository = $tartanManagerRepository;
        $this->categoryRepository = $categoryRepository;
        $this->storeManager = $storeManager;
        $this->messageManager = $messageManager;
        $this->redirect = $redirect;
        $this->productloader = $productloader;
    }

    /**
     * @param Observer $observer
     * @return $this|void
     * @throws LocalizedException
     */
    public function execute(Observer $observer)
    {
        $params = $this->request->getParams();
        $product = null;
        try {
            $product = $this->productloader->create()->load($params['product']);
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
        }
        if ($product && $product->getTypeId() == Configurable::TYPE_CODE)
        {
            $this->request->setParams(['super_attribute' => $params['super_attribute'][$product->getId()]]);
            $attributes = $params['super_attribute'][$product->getId()];
            $simpleProduct = $this->configurable->getProductByAttributes($attributes, $product);
            if ($simpleProduct->getCustomAttribute('tartan')) {
                if ($simpleProduct->getCustomAttribute('tartan')->getValue()) {
                    $optionId = $simpleProduct->getCustomAttribute('tartan')->getValue();
                    $attribute = $this->eavConfig->getAttribute('catalog_product', 'tartan');
                    $attribute->setStoreId(0);
                    $options = $attribute->getSource()->getAllOptions();
                    $tartanLabel = null;
                    $tartanId = null;
                    foreach($options as $option) {
                        if ($option['value'] == $optionId) {
                            $tartanLabel = $option['label'];
                            break;
                        }
                    }
                    if ($tartanLabel) {
                        $tartanId = strtok($tartanLabel, '-');
                        if($tartanId) {
                            $tartan = null;
                            try{
                                $tartan =  $this->tartanManagerRepository->getById($tartanId);
                            } catch (\Exception $e) {
                                $this->logger->critical($e->getMessage());
                            }
                            if ($tartan) {
                                if (!$tartan->getCanBuy()) {
                                    if ($tartan->getCategoryId()) {
                                        $params = ['tartan' => $tartanId];
                                        $urlParams = [];
                                        foreach ($params as $name=>$value){
                                            $urlParams[] = $name.'='.urlencode($value);
                                        }
                                        $urlParams = implode('&', $urlParams);
                                        $categoryUrl = null;
                                        try {
                                            $categoryUrl = $this->categoryRepository->get($tartan->getCategoryId(), $this->storeManager->getStore()->getId())->getUrl();
                                        } catch (\Exception $e) {
                                            $this->logger->critical($e->getMessage());
                                        }
                                        if ($categoryUrl) {
                                            if ($urlParams){
                                                $glue = '?';
                                                if (str_contains($categoryUrl, $glue)){
                                                    $glue = '&';
                                                }
                                                $categoryUrl .= $glue.$urlParams;
                                                $this->messageManager->addComplexErrorMessage(
                                                    'addRestrictedTartanMessage',
                                                    [
                                                        'category_url' => $categoryUrl,
                                                    ]
                                                );
                                                $observer->getRequest()->setParam('product', false);
                                                $observer->getControllerAction()->getResponse()->setRedirect($this->redirect->getRefererUrl());
                                                return $this;
                                            }
                                        }
                                    } else {
                                        $this->messageManager->addComplexErrorMessage(
                                            'addRestrictedTartanMessage',
                                            [
                                                'category_url' => '',
                                            ]
                                        );
                                        $observer->getRequest()->setParam('product', false);
                                        $observer->getControllerAction()->getResponse()->setRedirect($this->redirect->getRefererUrl());
                                        return $this;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
