<?php
namespace Mtc\ClansEvents\Block\Adminhtml\Event\Edit\Button;

use Magento\Framework\Registry;
use Magento\Backend\Model\UrlInterface;

class General
{
    /**
     * Url Builder
     *
     * @var UrlInterface
     */
    protected $urlBuilder;

    /**
     * Registry
     *
     * @var Registry
     */
    protected $registry;

    /**
     * General constructor.
     * @param UrlInterface $urlBuilder
     * @param Registry $registry
     */
    public function __construct(
        UrlInterface $urlBuilder,
        Registry $registry
    ) {
        $this->urlBuilder = $urlBuilder;
        $this->registry = $registry;
    }

    /**
     * @return null|int
     */
    public function getEventId()
    {
        $event = $this->registry->registry('events_data');
        return $event ? $event->getEventId() : null;
    }

    /**
     * Generate url by route and parameters
     *
     * @param   string $route
     * @param   array $params
     * @return  string
     */
    public function getUrl($route = '', $params = [])
    {
        return $this->urlBuilder->getUrl($route, $params);
    }
}
