<?php
namespace Mtc\ClansEvents\Controller\Adminhtml\Manage;

use Mtc\ClansEvents\Model\EventManager\ImageUploader;
use Magento\Backend\App\Action as ActionAlias;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;

class Upload extends ActionAlias
{
    /**
     * @var ImageUploader
     */
    private $imageUploader;

    /**
     * @param Context $context
     * @param ImageUploader $imageUploader
     */
    public function __construct(
        Context $context,
        ImageUploader $imageUploader
    ) {
        parent::__construct($context);
        $this->imageUploader = $imageUploader;
    }

    /**
     * @return ResultInterface
     */
    public function execute()
    {
        $result = $this->imageUploader->saveImageToMediaFolder($this->_request->getParam('param_name'));
        return $this->resultFactory->create(ResultFactory::TYPE_JSON)->setData($result);
    }
}
