<?php
namespace Mtc\ClansEvents\Block;

use Magento\Backend\Block\Template\Context;
use Magento\Cms\Model\Template\FilterProvider;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Stdlib\DateTime\TimezoneInterface;
use Magento\Framework\UrlInterface;
use Mtc\Clans\Api\ClanManagerRepositoryInterface;
use Mtc\ClansEvents\Model\ResourceModel\EventManager\CollectionFactory;
use Psr\Log\LoggerInterface;

class Events extends \Magento\Framework\View\Element\Template implements \Magento\Widget\Block\BlockInterface
{
    /**
     * @var string
     */
    protected $_template = 'Mtc_ClansEvents::events.phtml';

    /**
     * Constant
     */
    const DATE_FORMAT = 'd M Y';

    /**
     * @var CollectionFactory
     */
    private $eventManagerCollectionFactory;

    /**
     * @var UrlInterface
     */
    private $urlInterface;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var TimezoneInterface
     */
    private $timezone;

    /**
     * @var ClanManagerRepositoryInterface
     */
    private $clanManagerRepository;

    /**
     * @var FilterProvider
     */
    private $filterProvider;

    /**
     * @param Context $context
     * @param CollectionFactory $eventManagerCollectionFactory
     * @param UrlInterface $urlInterface
     * @param LoggerInterface $logger
     * @param TimezoneInterface $timezone
     * @param ClanManagerRepositoryInterface $clanManagerRepository
     * @param FilterProvider $filterProvider
     * @param array $data
     */
    public function __construct(
        Context $context,
        CollectionFactory $eventManagerCollectionFactory,
        UrlInterface $urlInterface,
        LoggerInterface $logger,
        TimezoneInterface $timezone,
        ClanManagerRepositoryInterface $clanManagerRepository,
        FilterProvider $filterProvider,
        array $data = []
    ) {
        $this->eventManagerCollectionFactory = $eventManagerCollectionFactory;
        $this->urlInterface = $urlInterface;
        $this->logger = $logger;
        $this->timezone = $timezone;
        $this->clanManagerRepository = $clanManagerRepository;
        $this->filterProvider = $filterProvider;
        parent::__construct($context, $data);
    }

    /**
     * @return mixed
     */
    public function getClan() {
        $clanId =  $this->_request->getParam('clan');
        if ($clanId) {
            try{
                return $this->clanManagerRepository->getById($clanId);
            } catch (\Exception $e) {
                $this->logger->critical($e->getMessage());
            }
        }
        return null;
    }

    /**
     * @return mixed
     */
    public function getEventCollection($clanId)
    {
        $sortOrder = 'desc';
        $eventManagerCollection = $this->eventManagerCollectionFactory->create();
        $blockTable = $eventManagerCollection->getTable('mtc_event_clan_link');
        $surnameTable = $eventManagerCollection->getTable('mtc_clan');
        $eventManagerCollection->addFieldToFilter(
            "is_active",
            ["eq" => true]
        )->addFieldToFilter(
            "clanLink.clan_id",
            ["eq" => $clanId]
        )->setOrder(
            "event_id",
            $sortOrder
        );
        $eventManagerCollection->getSelect()->joinLeft(['clanLink' => $blockTable], 'clanLink.event_id = main_table.event_id')
            ->joinLeft(['clanTable' => $surnameTable], 'clanTable.entity_id = clanLink.clan_id')
            ->order('main_table.event_id');
        return $eventManagerCollection;
    }

    /**
     * @param $urlkey
     * @return string
     */
    public function getEventManagerUrl($urlkey)
    {
        return $this->urlInterface->getUrl() . 'events/detail/index/id/' . $urlkey;
    }

    /**
     * @return string
     */
    public function getThumbnailImageURL($file)
    {
        if ($file == '') {
            return '';
        }
        return $this->getMediaUrl($file);
    }

    /**
     * Get file url
     * @param $file
     * @return string
     */
    private function getMediaUrl($file)
    {
        try {
            $file = ltrim(str_replace('\\', '/', $file), '/');
            return $this->_storeManager
                    ->getStore()
                    ->getBaseUrl(UrlInterface::URL_TYPE_MEDIA) . $file;
        } catch (\Exception $exception) {
            $this->logger->debug($exception->getMessage());
        }
    }

    /**
     * @param $date
     * @return string
     */
    public function changeDateFormat($date)
    {
        return $this->timezone->date(strtotime($date))->format(self::DATE_FORMAT);
    }

    /**
     * @param $content
     * @return mixed
     */
    public function contentFiltering($content)
    {
        try {
            $storeId = $this->_storeManager->getStore()->getId();
        } catch (NoSuchEntityException $exception) {
            $this->logger->debug($exception->getMessage());
        }
        return $this->filterProvider->getBlockFilter()->setStoreId($storeId)->filter($content);
    }
}
