<?php
namespace Mtc\ClansEvents\Controller\Adminhtml\Manage;

use Magento\Framework\Stdlib\DateTime\TimezoneInterface;
use Mtc\ClansEvents\Model\EventManager;
use Magento\Backend\Model\View\Result\Redirect as RedirectAlias;
use Magento\Framework\Controller\ResultInterface as ResultInterfaceAlias;
use Magento\Backend\App\Action\Context;
use Mtc\ClansEvents\Api\EventManagerRepositoryInterface;
use Mtc\ClansEvents\Model\EventManagerFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Backend\App\Action;
use Psr\Log\LoggerInterface;

class Save extends Action
{
    const DATE_FORMAT = 'Y-m-d';

    /**
     * @var EventManagerFactory
     */
    private $eventManagerFactory;

    /**
     * @var EventManagerRepositoryInterface
     */
    private $eventManagerRepository;

    /**
     * @var TimezoneInterface
     */
    private $timezone;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @param Context $context
     * @param EventManagerFactory $eventManagerFactory
     * @param EventManagerRepositoryInterface $eventManagerRepository
     * @param TimezoneInterface $timezone
     * @param LoggerInterface $logger
     */
    public function __construct(
        Context $context,
        EventManagerFactory $eventManagerFactory,
        EventManagerRepositoryInterface $eventManagerRepository,
        TimezoneInterface $timezone,
        LoggerInterface $logger
    ) {
        $this->eventManagerFactory = $eventManagerFactory;
        $this->eventManagerRepository = $eventManagerRepository;
        $this->timezone = $timezone;
        $this->logger = $logger;
        parent::__construct($context);
    }

    /**
     *
     * @return ResultInterfaceAlias
     */
    public function execute()
    {
        /** @var RedirectAlias $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        $data = $this->getRequest()->getPostValue();
        $model = $this->eventManagerFactory->create();
        if (!empty($data)) {
            $generalData = $data;
            $id = $generalData['event_id'];
            $generalData['date'] = $this->changeDateFormat($generalData['date']);
            /** @var EventManager $model */
            if ($id) {
                try {
                    $model = $this->eventManagerRepository->getById($id);
                } catch (LocalizedException $e) {
                    $this->messageManager
                        ->addErrorMessage(__('This event no longer exists.'));
                    $this->_getSession()->setFormData($data);
                    $this->_redirect('*/*/edit', ['id' => $id]);
                    return;
                }
            }
            if (!isset($generalData['links'])) {
                $this->messageManager
                    ->addErrorMessage(__('Please connect event with any clan.'));
                $this->_getSession()->setFormData($data);
                $this->_redirect('*/*/edit', ['id' => $id]);
                return;
            }
            if (isset($generalData['thumbnail_image'])) {
                if (str_contains($generalData['thumbnail_image'][0]['file'], 'EventManager')) {
                    $generalData['thumbnail_image'] = $generalData['thumbnail_image'][0]['file'];
                } else {
                    $generalData['thumbnail_image'] = 'EventManager/' .
                        $generalData['thumbnail_image'][0]['file'];
                }
            }
            $model->setData($generalData);
            try {
                $model->setUpdatedAt('');
                $this->eventManagerRepository->save($model);
                $this->messageManager->addSuccessMessage(__('You saved the event.'));
                $this->_getSession()->setFormData(false);
                // Check if 'Save and New'
                if ($this->getRequest()->getParam('back') == 'new') {
                    $this->_redirect('*/*/new', ['_current' => true]);
                    return;
                }
                // Check if 'Save and Continue'
                if ($this->getRequest()->getParam('back') == 'edit') {
                    $this->_redirect('*/*/edit', ['event_id' => $model->getEventId(), '_current' => true]);
                    return;
                }
                // Go to grid page
                $this->_redirect('*/*/');
                return;
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addExceptionMessage(
                    $e,
                    __('Something went wrong while saving the event.')
                );
            }
            $this->_getSession()->setFormData($data);
            $this->_redirect('*/*/edit', ['event_id' => $id]);
        }
    }

    /**
     * @param $date
     * @return string
     */
    private function changeDateFormat($date)
    {
        try {
            return $this->timezone->date($date)->format(self::DATE_FORMAT);
        } catch (\Exception $exception) {
            $this->logger->debug($exception->getMessage());
        }
    }
}

