<?php
namespace Mtc\ClansEvents\Controller\Adminhtml\Manage;

use Magento\Backend\Model\View\Result\Page;
use Mtc\ClansEvents\Model\EventManagerRepository;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Exception\NoSuchEntityException;

class Delete extends Action
{
    /**
     * @var string
     */
    const ACTION_RESOURCE = 'Mtc_ClansEvents::manage_event';

    /**
     * @var EventManagerRepository
     */
    private $eventManagerRepository;

    /**
     * Delete constructor.
     * @param Context $context
     * @param EventManagerRepository $eventManagerRepository
     */
    public function __construct(
        Context $context,
        EventManagerRepository $eventManagerRepository
    ) {
        $this->eventManagerRepository = $eventManagerRepository;
        parent::__construct($context);
    }

    /**
     *
     * @return Page
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('event_id');
        if ($id) {
            try {
                $this->eventManagerRepository->getById($id);
            } catch (NoSuchEntityException $e) {
                $this->messageManager->addErrorMessage(__('This event no longer exists.'));
                $this->_redirect('*/*/');
            }
            try {
                $this->eventManagerRepository->deleteById($id);
                $this->messageManager->addSuccessMessage(__('Event deleted'));
                $this->_redirect('*/*/');
            } catch (\Exception $e) {
                $this->messageManager->addExceptionMessage($e->getMessage());
                $this->_redirect('*/*/edit', ['event_id' => $id]);
            }
        }
    }
}
