<?php
namespace Mtc\ClansEvents\Api\Data;

/**
 * interface EventsManagerInterface
 * @api
 */
interface EventManagerInterface
{
    const ENTITY_ID = 'event_id';

    const EVENT_TITLE = 'event_title';

    const CALL_FOR_REPRESENTERS = 'call_for_representers';

    const DESCRIPTION = 'description';

    const THUMBNAIL_IMAGE = 'thumbnail_image';

    const IS_ACTIVE = 'is_active';

    const DATE = 'date';

    const CREATED_AT = 'created_at';

    const UPDATED_AT = 'updated_at';

    /**
     * @param int $eventId
     * @return $this
     */
    public function setEventId($eventId);

    /**
     * @return string
     */
    public function getEventId();

    /**
     * @param string $eventTitle
     * @return $this
     */
    public function setEventTitle($eventTitle);

    /**
     * @return string
     */
    public function getEventTitle();

    /**
     * @param string $callForRepresenters
     * @return $this
     */
    public function setCallForRepresenters($callForRepresenters);

    /**
     * @return string
     */
    public function getCallForRepresenters();

    /**
     * @param string $description
     * @return $this
     */
    public function setDescription(string $description);

    /**
     * @return string
     */
    public function getDescription();

    /**
     * @param string $thumbnailImage
     * @return $this
     */
    public function setThumbnailImage($thumbnailImage);

    /**
     * @return string
     */
    public function getThumbnailImage();

    /**
     * @param string $isActive
     * @return $this
     */
    public function setIsActive($isActive);

    /**
     * @return string
     */
    public function getIsActive();

    /**
     * @param string $date
     * @return $this
     */
    public function setDate($date);

    /**
     * @return string
     */
    public function getDate();

    /**
     * @param string $createdAt
     * @return $this
     */
    public function setCreatedAt($createdAt);

    /**
     * @return string
     */
    public function getCreatedAt();

    /**
     * @param string $updatedAt
     * @return $this
     */
    public function setUpdatedAt($updatedAt);

    /**
     * @return string
     */
    public function getUpdatedAt();

}
