<?php
namespace Mtc\Clans\Controller\Adminhtml\Surname;

use Magento\Framework\Controller\ResultInterface as ResultInterfaceAlias;
use Magento\Framework\View\Result\PageFactory;
use Mtc\Clans\Api\SurnameManagerRepositoryInterface;
use Magento\Backend\App\Action\Context;
use Magento\Backend\App\Action;

/**
 * This Class is used to add new or update existing record
 *
 * Class Edit
 */
class Edit extends Action
{
    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
    const ADMIN_RESOURCE = 'Mtc_Clans::manage_surname';

    /**
     * @var PageFactory
     */
    private $resultPageFactory;

    /**
     * @var SurnameManagerRepositoryInterface
     */
    private $eventManagerRepositoryInterface;

    /**
     * Edit constructor.
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param SurnameManagerRepositoryInterface $eventManagerRepositoryInterface
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        SurnameManagerRepositoryInterface $eventManagerRepositoryInterface
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->eventManagerRepositoryInterface = $eventManagerRepositoryInterface;
        parent::__construct($context);
    }

    /**
     * Edit CMS page
     * @return ResultInterfaceAlias
     */
    public function execute()
    {
        // 1. Get ID and create model and breadcrumbs
        $id = $this->getRequest()->getParam('entity_id');
        $model = $id?$this->eventManagerRepositoryInterface->getById($id):null;
        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('Mtc_Clans::surname')
            ->addBreadcrumb(__('Surname'), __('Surname'))
            ->addBreadcrumb(__('Manage Surname'), __('Manage Surname'));
        $resultPage->addBreadcrumb(
            $id ? __('Edit Surname') : __('New Surname'),
            $id ? __('Edit Surname') : __('New Surname')
        );
        $resultPage->getConfig()->getTitle()->prepend(__('Surnames'));
        $resultPage->getConfig()->getTitle()
            ->prepend($id ? $model->getSurname() : __('New Surname'));
        return $resultPage;
    }
}
