<?php
namespace Mtc\Clans\Controller\Adminhtml\Manage;

use Magento\Backend\App\Action;
use Magento\Framework\View\Result\PageFactory;
use Magento\Backend\App\Action\Context;

/**
 * Abstract class for actions
 * abstract AbstractController
 */
abstract class AbstractController extends Action
{
    /**
     * @var PageFactory
     */
    private $resultPageFactory;

    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory
    ) {
        $this->resultPageFactory = $resultPageFactory;
        parent::__construct($context);
    }

    /**
     * this method is used to init breadcrumbs
     * @param $resultPage
     * @return mixed
     */
    public function _init($resultPage)
    {
        $resultPage->setActiveMenu('Mtc_Clans');
        $resultPage->addBreadcrumb(__('Clan'), __('Manager'));
        $resultPage->addBreadcrumb(__('Manage Clans'), __('Manage Clans'));
        $resultPage->getConfig()->getTitle()->prepend(__('Manage Clans'));
        return $resultPage;
    }

    /**
     * Check the permission to run it
     *
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Mtc_Clans::manage_clan');
    }
}
