<?php
namespace Mtc\Clans\Api;

use Mtc\Clans\Api\Data\SurnameManagerInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Declared inter
 * interface SurnameManagerRepositoryInterface
 */
interface SurnameManagerRepositoryInterface
{
    /**
     * Save surname.
     *
     * @param SurnameManagerInterface $event
     * @return mixed
     */
    public function save(SurnameManagerInterface $event);

    /**
     * Retrieve surname.
     *
     * @param $surname
     * @return mixed
     */
    public function getById($surname);

    /**
     * Retrieve list matching the specified criteria.
     *
     * @param SearchCriteriaInterface $searchCriteria
     * @return mixed
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Delete surname.
     *
     * @param SurnameManagerInterface $surname
     * @return mixed
     */
    public function delete(SurnameManagerInterface $surname);

    /**
     * Delete surname by ID.
     *
     * @param $surname
     * @return mixed
     */
    public function deleteById($surname);
}
