<?php
namespace Mtc\Clans\Model;

use Magento\Framework\Exception\LocalizedException;
use Mtc\Clans\Api\Data\ClanManagerInterface;
use Mtc\Clans\Model\ResourceModel\ClanManager as ClanManagerResourceModel;
use Magento\Framework\DataObject\IdentityInterface;
use Magento\Framework\Model\AbstractExtensibleModel;

/**
 * This model class is used for the Curd operation of Clans
 *
 * Class ClanManager
 */
class ClanManager extends AbstractExtensibleModel implements ClanManagerInterface, IdentityInterface
{
    const STATUS_ENABLED = 1;
    const STATUS_DISABLED = 0;

    /**
     * @var PAGE_CACHE
     */
    const CACHE_TAG = 'mtc_clan_manager';

    /**
     * @var PAGE_CACHE|string
     */
    protected $_cacheTag = self::CACHE_TAG;

    /**
     * Constructor to initialize ResourceModel
     */
    public function _construct()
    {
        $this->_init(ClanManagerResourceModel::class);
    }

    /**
     * Return unique ID(s) for each object in system
     *
     * @return string[]
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId(), self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * Prepare clan's shop statuses.
     *
     *
     * @return array
     */
    public function getAvailableStatuses()
    {
        return [self::STATUS_ENABLED => __('Yes'), self::STATUS_DISABLED => __('No')];
    }

    /**
     * @param $entityId
     * @return array|null
     * @throws LocalizedException
     */
    public function getSurnames($entityId)
    {
        $blockTable = $this->getResource()->getTable('mtc_surname_clan_link');
        $surnameTable = $this->getResource()->getTable('mtc_surname');
        $collection = $this->getResourceCollection()
            ->addFieldToFilter('main_table.entity_id', $entityId);
        $collection->getSelect()
            ->joinLeft(['surname' => $blockTable], 'main_table.entity_id = surname.clan_id')
            ->joinLeft(['surnameTable' => $surnameTable], 'surname.surname_id = surnameTable.entity_id')
            ->order('main_table.entity_id');

        return $collection->getData();
    }

    /**
     * @param $entityId
     * @return array|null
     * @throws LocalizedException
     */
    public function getTartans($entityId)
    {
        $blockTable = $this->getResource()->getTable('mtc_clan_tartan_link');
        $tartanTable = $this->getResource()->getTable('mtc_tartan');
        $collection = $this->getResourceCollection()
            ->addFieldToFilter('main_table.entity_id', $entityId);
        $collection->getSelect()
            ->joinLeft(['tartanLink' => $blockTable], 'main_table.entity_id = tartanLink.clan_id', ['clan_id', 'tartan_id'])
            ->joinLeft(['tartanTable' => $tartanTable], 'tartanLink.tartan_id = tartanTable.entity_id', ['tartan_image', 'tartan_id', 'name', 'tartan_entity_id'=> 'entity_id'])
            ->where('tartanLink.tartan_id', NULL, 'neq')
            ->order('main_table.entity_id');
        return $collection->getData();
    }

    /**
     * @param int $entityId
     * @return $this
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * @return int
     */
    public function getEntityId()
    {
        return $this->getData(self::ENTITY_ID);
    }

    /**
     * @param int $categoryId
     * @return $this
     */
    public function setCategoryId($categoryId)
    {
        return $this->setData(self::CATEGORY_ID, $categoryId);
    }

    /**
     * @return int
     */
    public function getCategoryId()
    {
        return $this->getData(self::CATEGORY_ID);
    }

    /**
     * @param string $clanId
     * @return $this
     */
    public function setClanId($clanId)
    {
        return $this->setData(self::CLAN_ID, $clanId);
    }

    /**
     * @return string
     */
    public function getClanId()
    {
        return $this->getData(self::CLAN_ID);
    }

    /**
     * @param string $clan
     * @return $this
     */
    public function setClan($clan)
    {
        return $this->setData(self::CLAN, $clan);
    }

    /**
     * @return string
     */
    public function getClan()
    {
        return $this->getData(self::CLAN);
    }

    /**
     * @param string $altName
     * @return $this
     */
    public function setAltName($altName)
    {
        return $this->setData(self::ALT_NAME, $altName);
    }

    /**
     * @return string
     */
    public function getAltName()
    {
        return $this->getData(self::ALT_NAME);
    }

    /**
     * @param string $clanChief
     * @return $this
     */
    public function setClanChief($clanChief)
    {
        return $this->setData(self::CLAN_CHIEF, $clanChief);
    }

    /**
     * @return string
     */
    public function getClanChief()
    {
        return $this->getData(self::CLAN_CHIEF);
    }

    /**
     * @param string $plant
     * @return $this
     */
    public function setPlant($plant)
    {
        return $this->setData(self::PLANT, $plant);
    }

    /**
     * @return string
     */
    public function getPlant()
    {
        return $this->getData(self::PLANT);
    }

    /**
     * @param string $clanSoc
     * @return $this
     */
    public function setClanSoc($clanSoc)
    {
        return $this->setData(self::CLAN_SOC, $clanSoc);
    }

    /**
     * @return string
     */
    public function getClanSoc()
    {
        return $this->getData(self::CLAN_SOC);
    }

    /**
     * @param string $clanWeb
     * @return $this
     */
    public function setClanWeb($clanWeb)
    {
        return $this->setData(self::CLAN_WEB, $clanWeb);
    }

    /**
     * @return string
     */
    public function getClanWeb()
    {
        return $this->getData(self::CLAN_WEB);
    }

    /**
     * @param string $clanEmail
     * @return $this
     */
    public function setClanEmail($clanEmail)
    {
        return $this->setData(self::CLAN_EMAIL, $clanEmail);
    }

    /**
     * @return string
     */
    public function getClanEmail()
    {
        return $this->getData(self::CLAN_EMAIL);
    }

    /**
     * @param string $clanMapPath
     * @return $this
     */
    public function setClanMapPath($clanMapPath)
    {
        return $this->setData(self::CLAN_MAP_PATH, $clanMapPath);
    }

    /**
     * @return string
     */
    public function getClanMapPath()
    {
        return $this->getData(self::CLAN_MAP_PATH);
    }

    /**
     * @param string $clanInfo
     * @return $this
     */
    public function setClanInfo($clanInfo)
    {
        return $this->setData(self::CLAN_INFO, $clanInfo);
    }

    /**
     * @return string
     */
    public function getClanInfo()
    {
        return $this->getData(self::CLAN_INFO);
    }

    /**
     * @param string $clanShop
     * @return $this
     */
    public function setClanShop($clanShop)
    {
        return $this->setData(self::CLAN_SHOP, $clanShop);
    }

    /**
     * @return string
     */
    public function getClanShop()
    {
        return $this->getData(self::CLAN_SHOP);
    }

    /**
     * @param string $createdAt
     * @return $this
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @param string $updatedAt
     * @return $this
     */
    public function setUpdatedAt($updatedAt)
    {
        return $this->setData(self::UPDATED_AT);
    }

    /**
     * @return string
     */
    public function getUpdatedAt()
    {
        return $this->getData(self::UPDATED_AT);
    }
}
