<?php
namespace Mtc\Clans\Block\Adminhtml\Clan\Edit\Tab;

use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Phrase;
use Mtc\Clans\Model\ClanManager;
use Magento\Framework\Data\Form;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Registry;
use Magento\Framework\Data\FormFactory;

class Main extends Generic implements TabInterface
{

    /**
     * @var CollectionFactory
     */
    private $categoryCollection;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param FormFactory $formFactory
     * @param CollectionFactory $categoryCollection
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        FormFactory $formFactory,
        CollectionFactory $categoryCollection,
        array $data = []
    )
    {
        $this->categoryCollection = $categoryCollection;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /**
     * @return array
     * @throws LocalizedException
     */
    private function getCategoriesList()
    {
        $categories = [];
        $collection = $this->categoryCollection->create();
        $collection->addAttributeToSelect('name')
            ->addAttributeToSelect('url_key')
            ->addAttributeToSelect('url_path');
        $collection->setStoreId(\Magento\Store\Model\Store::DEFAULT_STORE_ID);
        /* @var $collection \Magento\Catalog\Model\ResourceModel\Category\Collection */
        foreach ($collection as $category) {
            $structure = explode('/', $category->getPath());
            $pathSize = count($structure);
            if ($pathSize > 1) {
                $path = [];
                for ($i = 1; $i < $pathSize; $i++) {
                    $name = $collection->getItemById((int)$structure[$i])->getName();
                    $path[] = str_replace('/', '\\' . '/', $name);
                }
                /** @var string $index */
                $index = implode('/', $path);
                $categories[$category->getId()] = $index;
            }
        }
        return $categories;
    }

    /**
     * Prepare form
     *
     * @return $this
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     * @throws LocalizedException
     */
    protected function _prepareForm(): static
    {
        /* @var $model ClanManager */
        $model = $this->_coreRegistry->registry('clans_data');
        /*
         * Checking if user have permissions to save information
         */
        if ($this->_isAllowedAction('Mtc_Clans::save')) {
            $isElementDisabled = false;
        } else {
            $isElementDisabled = true;
        }

        /** @var Form $form */
        $form = $this->_formFactory->create();

        $fieldset = $form->addFieldset('base_fieldset', ['legend' => __('General Settings')]);

        if ($model->getEntityId()) {
            $fieldset->addField('entity_id', 'hidden', ['name' => 'entity_id']);
        }

        $fieldset->addField(
            'clan',
            'text',
            [
                'name' => 'clan',
                'label' => __('Clan'),
                'title' => __('Clan'),
                'required' => true,
                'disabled' => $isElementDisabled
            ]
        );

        $fieldset->addField(
            'category_id',
            'select',
            [
                'label' => __('Clan Category'),
                'title' => __('Clan Category'),
                'name' => 'category_id',
                'required' => false,
                'options' => $this->getCategoriesList(),
                'disabled' => $isElementDisabled
            ]
        );

        $fieldset->addField(
            'alt_name',
            'text',
            [
                'name' => 'alt_name',
                'label' => __('Alt Name'),
                'title' => __('Alt Name'),
                'required' => false,
                'disabled' => $isElementDisabled
            ]
        );

        $fieldset->addField(
            'clan_chief',
            'text',
            [
                'name' => 'clan_chief',
                'label' => __('Clan Chief'),
                'title' => __('Clan Chief'),
                'required' => false,
                'disabled' => $isElementDisabled
            ]
        );

        $fieldset->addField(
            'clan_motto',
            'text',
            [
                'name' => 'clan_motto',
                'label' => __('Clan Motto'),
                'title' => __('Clan Motto'),
                'required' => false,
                'disabled' => $isElementDisabled
            ]
        );

        $fieldset->addField(
            'plant',
            'text',
            [
                'name' => 'plant',
                'label' => __('Plant'),
                'title' => __('Plant'),
                'required' => false,
                'disabled' => $isElementDisabled
            ]
        );

        $fieldset->addField(
            'clan_soc',
            'text',
            [
                'name' => 'clan_soc',
                'label' => __('Clan Soc'),
                'title' => __('Clan Soc'),
                'required' => false,
                'disabled' => $isElementDisabled
            ]
        );

        $fieldset->addField(
            'clan_web',
            'text',
            [
                'name' => 'clan_web',
                'label' => __('Clan Web'),
                'title' => __('Clan Web'),
                'required' => false,
                'disabled' => $isElementDisabled
            ]
        );

        $fieldset->addField(
            'clan_email',
            'text',
            [
                'name' => 'clan_email',
                'label' => __('Clan Email'),
                'title' => __('Clan Email'),
                'required' => false,
                'disabled' => $isElementDisabled
            ]
        );

        $fieldset->addField(
            'clan_map_path',
            'text',
            [
                'name' => 'clan_map_path',
                'label' => __('Clan Map Path'),
                'title' => __('Clan Map Path'),
                'required' => false,
                'disabled' => $isElementDisabled
            ]
        );

        $fieldset->addField(
            'clan_info',
            'textarea',
            [
                'name' => 'clan_info',
                'label' => __('Clan Info'),
                'title' => __('Clan Info'),
                'required' => false,
                'disabled' => $isElementDisabled
            ]
        );

        $fieldset->addField(
            'clan_shop',
            'select',
            [
                'label' => __('Clan Shop'),
                'title' => __('Clan Shop'),
                'name' => 'clan_shop',
                'required' => false,
                'options' => $model->getAvailableStatuses(),
                'disabled' => $isElementDisabled
            ]
        );

        $form->setValues($model->getData());
        $this->setForm($form);
        return parent::_prepareForm();
    }

    /**
     * Prepare label for tab
     *
     * @return Phrase
     */
    public function getTabLabel()
    {
        return __('General');
    }

    /**
     * Prepare title for tab
     *
     * @return Phrase
     */
    public function getTabTitle()
    {
        return __('General');
    }

    /**
     * {@inheritdoc}
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function isHidden()
    {
        return false;
    }

    /**
     * Check permission for passed action
     *
     * @param string $resourceId
     * @return bool
     */
    protected function _isAllowedAction($resourceId)
    {
        return $this->_authorization->isAllowed($resourceId);
    }

}
