<?php
namespace Mtc\Clans\Block\Adminhtml\Clan\Edit\Tab;

use Exception;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Grid\Extended;
use Magento\Backend\Helper\Data;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Registry;
use Mtc\Clans\Model\SurnameManagerFactory;

class Surname extends Extended
{

    /**
     * Core registry
     *
     * @var Registry
     */
    private $coreRegistry = null;


    /**
     * @var SurnameManagerFactory
     */
    private $surnameManager;

    /**
     * @param Context $context
     * @param Data $backendHelper
     * @param SurnameManagerFactory $surnameManager
     * @param Registry $coreRegistry
     * @param array $data
     */
    public function __construct(
        Context $context,
        Data $backendHelper,
        SurnameManagerFactory $surnameManager,
        Registry $coreRegistry,
        array $data = []
    ) {

        $this->surnameManager = $surnameManager;
        $this->coreRegistry = $coreRegistry;
        parent::__construct($context, $backendHelper, $data);
    }

    /**
     * @return void
     * @throws FileSystemException
     */
    public function _construct()
    {
        parent::_construct();
        $this->setId('clans_surname_grid');
        $this->setDefaultSort('entity_id');
        $this->setUseAjax(true);
        if ($this->isReadonly()) {
            $this->setFilterVisibility(false);
        }
    }

    /**
     * @param $column
     * @return $this|Surname
     * @throws LocalizedException
     */
    protected function _addColumnFilterToCollection($column)
    {
        if ($column->getId() == 'in_surnames') {
            $blockIds = $this->_getSelectedBlocks();
            if (empty($blockIds)) {
                $blockIds = 0;
            }

            if ($column->getFilter()->getValue()) {
                $this->getCollection()->addFieldToFilter('entity_id', ['in' => $blockIds]);
            } else {
                if ($blockIds) {
                    $this->getCollection()->addFieldToFilter('entity_id', ['nin' => $blockIds]);
                }
            }
        } else {
            parent::_addColumnFilterToCollection($column);
        }

        return $this;
    }

    /**
     * Prepare collection
     *
     * @return Extended
     */
    protected function _prepareCollection()
    {
        $collection = $this->surnameManager->create()
            ->getCollection();

        if ($this->isReadonly()) {
            $blockIds = $this->_getSelectedBlocks();
            if (empty($blockIds)) {
                $blockIds = [0];
            }

            $collection->addFieldToFilter('entity_id', ['in' => $blockIds]);
        }

        $this->setCollection($collection);
        return parent::_prepareCollection();
    }

    /**
     * @return mixed|null
     */
    protected function _getBlock()
    {
        return $this->coreRegistry->registry('current_clans_surname');
    }

    /**
     * @return int
     */
    public function isReadonly()
    {
        return 0;
    }

    /**
     * @return Surname
     * @throws Exception
     */
    protected function _prepareColumns()
    {
        if (!$this->isReadonly()) {
            $this->addColumn(
                'in_surnames',
                [
                    'type' => 'checkbox',
                    'name' => 'in_surnames',
                    'values' => $this->_getSelectedBlocks(),
                    'align' => 'center',
                    'index' => 'entity_id',
                    'header_css_class' => 'col-select',
                    'column_css_class' => 'col-select'
                ]
            );
        }

        $this->addColumn(
            'surname_id',
            [
                'header' => __('Surname Id'),
                'sortable' => true,
                'index' => 'surname_id',
                'header_css_class' => 'col-id',
                'column_css_class' => 'col-id'
            ]
        );

        $this->addColumn(
            'surname',
            [
                'header' => __('Surname'),
                'index' => 'surname',
                'header_css_class' => 'col-name',
                'column_css_class' => 'col-name'
            ]
        );

        return parent::_prepareColumns();
    }

    /**
     * @return array|mixed|string|null
     */
    public function getGridUrl()
    {

        return $this->getData('grid_url') ?
            $this->getData('grid_url') :
            $this->getUrl('*/*/surnameGrid', ['_current' => true]);
    }

    /**
     * @return int[]|string[]
     */
    public function _getSelectedBlocks()
    {
        $blocks = $this->getSurnames();
        if (!is_array($blocks)) {
            $blocks = array_keys($this->getRuleBlocks());
        }
        return $blocks;
    }

    /**
     * @return array
     */
    public function getRuleBlocks()
    {
        $id = $this->getRequest()->getParam('entity_id');
        $blocksArr = [];
        foreach ($this->coreRegistry->registry('current_clans_surname')->getSurnames($id) as $blocks) {
            $blocksArr[$blocks['entity_id']] = ['position' => '0'];
        }
        return $blocksArr;
    }
}
