/**
 * Copyright © Mtc. All rights reserved.
 * See MS-LICENSE.txt for license details.
 */

define(
    [
    'jquery',
    'jquery/ui'
    ], function ($) {

        $.widget(
            'mtc.hoverList', {
                options: {
                    hoverData: {},
                    origData: {},
                    itemsSelector: ".product-item",
                    itemImageSelector: "product-image-photo",
                    hoverImageSelector: "product-hover-image-photo",
                    hoverImageWrapSelector: "hoverImageWrap"
                },

                _create: function () {
                    this._bind();
                },

                _bind: function () {
                    var self = this;
                    $(this.options.itemsSelector)
                    .mouseover(
                        function (event) {
                            self.onMouseOver(event)}
                    )
                    .mouseout(
                        function (event) {
                            self.onMouseOut(event)}
                    );
                },

                onMouseOver: function (event) {
                    var $elementTarget = $(event.target);
                    if (!$elementTarget.hasClass(this.options.itemImageSelector)) {
                        return;
                    }
                    var $element = $(event.currentTarget);
                    var productId = $('.price-box', $element).attr('data-product-id');
                    if (this.options.hoverData[productId] && $('.'+this.options.hoverImageSelector, $element).length < 1) {
                        var $image = $('.'+this.options.itemImageSelector, $element),
                        $image_hover = $('<img class="' + this.options.hoverImageSelector + '" />'),
                        $image_hover_object = new Image(),
                        $this = this;
                        // this.options.origData[productId] = $image.attr('src');
                        // $image.attr('src', this.options.hoverData[productId]);
                        $image_hover.attr('src', $this.options.hoverData[productId]);

                        $image_hover_object.onload = function () {
                            $image.after('<div class="' + $this.options.hoverImageWrapSelector + '"></div>');
                            $('.' + $this.options.hoverImageWrapSelector, $element).append($image_hover);
                            setTimeout(
                                function () {
                                    $('.' + $this.options.hoverImageWrapSelector, $element).addClass('loaded');
                                }, 20
                            );
                        };
                        $image_hover_object.src = this.options.hoverData[productId];
                    }
                },

                onMouseOut: function (event) {
                    var $element = $(event.currentTarget);
                    var productId = $('.price-box', $element).attr('data-product-id');
                    if (this.options.origData[productId]) {
                        var $image = $('.'+this.options.itemImageSelector, $element);
                        $image.attr('src', this.options.origData[productId]);
                    }
                }
            }
        );

        return $.mtc.hoverList;

    }
);

