<?php

namespace Mtc\BypassImageCache\Plugin\Swatches;


use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem;
use Magento\Swatches\Helper\Media;
use Mtc\BypassImageCache\Model\IsAllowed;

class MediaHelper
{
    /**
     * @var IsAllowed
     */
    protected $isAllowed;

    /**
     * @var \Magento\Framework\Filesystem\Directory\ReadInterface
     */
    protected $mediaDirectory;

    public function __construct(
        IsAllowed $isAllowed,
        Filesystem $filesystem
    ) {
        $this->isAllowed = $isAllowed;
        $this->mediaDirectory = $filesystem->getDirectoryRead(DirectoryList::MEDIA);
    }

    public function aroundGetSwatchAttributeImage(Media $subject, callable $proceed, $swatchType, $file)
    {
        $absoluteImagePath = $this->getAbsolutePath($subject, $file);
        if ($this->isAllowed->execute($absoluteImagePath, "swatch")) {
            return $subject->getSwatchMediaUrl() . $file;
        }
        return $proceed($swatchType, $file);
    }

    /*
     * Disallow generation of image variations for direct path type images
     * */
    public function aroundGenerateSwatchVariations(Media $subject, callable $proceed, $imageUrl)
    {
        $absoluteImagePath = $this->getAbsolutePath($subject, $imageUrl);
        if (!$this->isAllowed->execute($absoluteImagePath, "swatch")) {
            $proceed($imageUrl);
        }
    }

    protected function getAbsolutePath($subject, $image)
    {
        return $this->mediaDirectory
            ->getAbsolutePath($subject->getSwatchMediaPath() . '/' . $image);
    }
}
