<?php

namespace Mtc\BypassImageCache\Plugin\Model\View\Asset;


use Magento\Catalog\Model\View\Asset\Image;
use Mtc\BypassImageCache\Model\IsAllowed;

class ImagePlugin
{
    /**
     * @var IsAllowed
     */
    protected $isAllowed;

    public function __construct(IsAllowed $isAllowed)
    {
        $this->isAllowed = $isAllowed;
    }

    public function afterGetUrl(Image $subject, $result)
    {
        if ($this->isAllowed->execute($subject->getPath(), $subject->getSourceContentType())) {
            return $subject->getContext()->getBaseUrl().$subject->getFilePath();
        }
        return $result;
    }
}
