<?php

namespace Mtc\BypassImageCache\Model;

use Mtc\BypassImageCache\Model\System\Config\Source\Extensions;
use Mtc\BypassImageCache\Model\System\Config\Source\Types;
use Psr\Log\LoggerInterface;

class IsAllowed
{
    /**
     * @var ConfigReader
     */
    private $configReader;

    /**
     * @var LoggerInterface
     */
    private $logger;

    public function __construct(
        ConfigReader $configReader,
        LoggerInterface $logger
    ) {
        $this->configReader = $configReader;
        $this->logger = $logger;
    }

    public function execute($image, $type)
    {
        $allowedTypes = $this->configReader->getAllowedTypes();
        $allowedExtensions = $this->configReader->getAllowedExtensions();
        if ((in_array(Types::ALL_TYPES, $allowedExtensions) ||  in_array($this->getImageExtension($image), $allowedExtensions)) &&
            (in_array(Types::ALL_TYPES, $allowedTypes) || in_array($type, $allowedTypes))
        ) {
            return true;
        }
        return false;
    }

    protected function getImageExtension($image)
    {
        try {
            $fileExtension = pathinfo($image, PATHINFO_EXTENSION);
            switch ($fileExtension) {
                case 'gif':
                    return Extensions::IMAGE_GIF;
                case 'webp':
                    return Extensions::IMAGE_WEBP;
                case 'png':
                    return Extensions::IMAGE_PNG;
                case 'jpg':
                case 'jpeg':
                    return Extensions::IMAGE_JPG_JPEG;
                default:
                    return null;
            }
        } catch (\Exception $exception) {
            $this->logger->critical(
                "Error while checking image type in extension Mtc_BypassImageCache: ". $exception->getMessage()
            );
        }
        return false;
    }
}
