<?php

namespace Mtc\BypassImageCache\Model;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

class ConfigReader
{
    const XML_BASE_CONFIG_PATH = "direct_image_path/general/";

    protected $scopeConfig;

    protected $_allowedExtensions = null;

    protected $_allowedTypes = null;

    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    public function getAllowedExtensions()
    {
        if ($this->_allowedExtensions === null) {
            $this->_allowedExtensions = $this->explodeValue($this->getConfig("extensions"));
        }
        return $this->_allowedExtensions;
    }

    public function getAllowedTypes()
    {
        if ($this->_allowedTypes === null) {
            $this->_allowedTypes = $this->explodeValue($this->getConfig("image_types"));
        }
        return $this->_allowedTypes;
    }

    public function getConfig($path)
    {
        return $this->scopeConfig->getValue(self::XML_BASE_CONFIG_PATH.$path, ScopeInterface::SCOPE_STORE);
    }

    protected function explodeValue($value)
    {
        if($value) {
            return explode(',', $value);
        }
        return [];
    }
}
