<?php
    /**
     * @author Josh Carter <josh@interjar.com>
     */

    namespace Interjar\BugSnag\Plugin;

    use Bugsnag\Client;
    use Interjar\BugSnag\Helper\Config;

    /**
     * Base class for any ExceptionCatcher plugin.
     *
     * @package Interjar\BugSnag\Plugin
     */
    abstract class BaseExceptionCatcherPlugin
    {

        /**
         * ExceptionCatcher constructor
         *
         * @param Config $config
         */
        public function __construct(
           protected Config $config
        ) {
        }

        /**
         * Handle an exception and attempt to send it to Bugsnag.
         *
         * @param \Exception $exception
         */
        protected function handleException(
            \Exception $exception
        ) {
            if ($this->config->getConfiguration()) {
                $client = new Client($this->config->getConfiguration(), null, Client::makeGuzzle());
                $client->notifyException($exception);
            }
        }

    }
