<?php


    namespace Mtc\AutoInvoice\Observer\Sales\Order\After;

    use Magento\Framework\Event\Observer;
    use Psr\Log\LoggerInterface;
    use Mtc\AutoInvoice\Api\InvoiceProcessInterface;
    use Mtc\AutoInvoice\Helper\Data as HelperData;

class InvoiceProcess implements \Magento\Framework\Event\ObserverInterface
{

    public function __construct(
        HelperData $helperData,
        LoggerInterface $logger,
        InvoiceProcessInterface $invoiceProcess
    ) {
        $this->helperData = $helperData;
        $this->logger = $logger;
        $this->invoiceProcess = $invoiceProcess;
    }

    /**
     * @inheritDoc
     */
    public function execute(Observer $observer)
    {
        /* @var $order \Magento\Sales\Model\Order */
        $order = $observer->getEvent()->getOrder();

        $rules = $this->helperData->getProcessingRules();
        $orderPaymentMethod = $order->getPayment()->getMethod();
        $findMethod = array_keys(array_combine(array_keys($rules), array_column($rules, HelperData::RULE_PAYMENT_METHOD)), $orderPaymentMethod);

        $items  = $this->invoiceProcess->getItemsToProcess($order->getIncrementId());
        foreach ($items as $order) {
            if ($findMethod && count($findMethod) > 0) {
                try {
                    $this->logger->info(
                        sprintf(
                            'Observer Invoicing order #%s',
                            $order->getIncrementId()
                        )
                    );
                    $this->invoiceProcess->invoice($order);
                } catch (\Exception $ex) {
                    $this->logger->error($ex->getMessage());
                }
                $this->logger->info('Auto invoice procedure completed.');
            }
        }

        return $this;
    }
}
