<?php

namespace Mtc\LayoutBrowser\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Mtc\LayoutBrowser\LayoutBrowser;

/**
 * Class LayoutBrowserController
 *
 * @package Mtc\LayoutBrowser
 */
class LayoutBrowserController extends Controller
{
    /**
     * Render the page
     *
     * @param Request $request
     * @param LayoutBrowser $layout_browser
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request, LayoutBrowser $layout_browser)
    {
        // update first line of less files with layout folder
        $layout_browser->updateImportPath(base_path('/core/css/import.less'));

        $template_menu = $layout_browser->getNavigation(dirname(__DIR__, 3). '/resources/templates/layouts');

        // pattern and layouts path name
        $pattern_path_name = dirname(__DIR__, 3). '/resources/templates/patterns';
        $pattern_directories = $layout_browser->getPatternDirectories($pattern_path_name);

        $template_info = [];
        $template_info['assets'] = [];

        if ($request->filled('twig_template_name')) {
            $twig_template_name = clean_db($request->input('twig_template_name'));
            $page_meta['title'] = 'Viewing layout' . $twig_template_name . ' on ' . config('app.name');
            $page_meta['page_title'] = 'Sample page';

        } elseif ($request->input('patterns') == true) {

            $page_meta['title'] = 'Pattern Browser for ' . config('app.name');
            $twig_template_name = '/chop/patterns.twig';

            foreach ($pattern_directories as $pattern_name) {
                $files = [];

                foreach (glob($pattern_path_name . '/' . $pattern_name . "/*.twig") as $filename) {
                    $files[] = basename($filename);
                }

                $template_info['pattern_names'][] = $pattern_name;
                $template_info['pattern_paths'][] = $pattern_path_name . '/' . $pattern_name;
                $template_info['patterns'][] = $files;

            }

        } else {

            $page_meta['title'] = 'Style Guide for ' . config('app.name');
            $twig_template_name = '/chop/style_guide.twig';

            $breadcrumbs = [
                [
                    'url' => '/',
                    'name' => 'Home',
                ], [
                    'url' => '/about',
                    'name' => 'About',
                ], [
                    'url' => '/careers',
                    'name' => 'Careers',
                ]
            ];


        }

        // get template assets info and add to array
        $template_info['assets'] = $layout_browser->getAssets($twig_template_name);

        // add page_meta data
        $page_meta['robots'] = 'noindex, nofollow';

        return template($twig_template_name, [
            'page_meta' => $page_meta,
            'breadcrumbs' => $breadcrumbs ?? [],
            'template_info' => $template_info,
            'template_menu' => $template_menu
        ]);

    }

    /**
     * redirect /core/css to /layout-browser/
     * Has to be done in code as it conflicts with QSA
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function moveToLayoutBrowser()
    {
        return redirect(route('layout-browser'));
    }
}
