/*
 * Mobile Thumbs Slideshow
 */

function thumbsSlideShow() {

    'use strict';

    if ($('.thumbs li').length > 1) {

        $('.thumbs').slick({
            dots: false,
            arrows: false,
            responsive: [
                {
                    breakpoint: window.breakpoints.mobile + 1,
                    settings: {
                        slidesToShow: 5,
                        slidesToScroll: 5
                    }
                },
                {
                    breakpoint: 481,
                    settings: {
                        slidesToShow: 4,
                        slidesToScroll: 4
                    }
                },
                {
                    breakpoint: 400,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 3
                    }
                }
            ]
        });
    }
}

/*
 * Overlay Images on Mobile
 */

function largeImageOverlay() {

    'use strict';

    if (matchesMediaQuery(0, window.breakpoints.mobile)) {
        $('.thumbs li a').mtcOverlay({
            padding: '0'
        });
    } else {
        $('.thumbs li a').mtcOverlay('destroy');
    }
}

/*
 * Enable Zoom
 */

function enableZoom() {

    'use strict';

    // if on mobile and zoom is active destroy it
    if (matchesMediaQuery(0, window.breakpoints.mobile) && $('.enableZoom .zoom').length) {
        $('.enableZoom').mtcZoom('destroy');
    } else if (matchesMediaQuery(window.breakpoints.mobile + 1) && $('.enableZoom').length) {
        $(".enableZoom").mtcZoom({
            enableGallery: true,
            displayLoading: true,
            hideMessageOnLaunch: true,
            message: 'Tap or mouseover to activate zoom<i class="fa fa-plus"></i>'
        });
    }
}

$(document).ready(function () {

    'use strict';

/*
 * Item Back Button
 */

    $('.itemBackButton').on('click', function (e) {
        e.preventDefault();
        window.history.back();
    });

/*
 * Colour Linked Items Change
 */

    if ($('#colourLinkedItems').length) {

        $('body').on('change', '#colourLinkedItems', function () {
            var link = $(this).find(':selected').data('link');

            if (link !== undefined) {
                window.location.href = link;
            }
        });

    }

/*
 * Mobile Thumbs Slideshow
 */

    if (matchesMediaQuery(0, window.breakpoints.mobile)) {
        thumbsSlideShow();
    }

/*
 * MTC Zoom
 * Provides gallery and zoom functions on item page
 */

    enableZoom();

/*
 * Overlay Images on Mobile
 */

    largeImageOverlay();

/*
 * Description Accordion
 */

    if ($('.accordionWrapper').length) {

        // hide all accordion content
        $('.accordionContent').hide().removeClass('accordionContentOpen');

        // show open accordion content
        $('.accordionOpen .accordionContent').show().addClass('accordionContentOpen');

        $('.accordionHeading').on('click', function () {
            var $this = $(this);

            $('.accordionContentWrap').removeClass('accordionOpen');

            // remove class form all other
            $('.accordionHeading').removeClass('accordionHeadingOpen');

            // slide up any open accordion
            $this.parents('.accordionWrapper').children().find('.accordionContent').slideUp();

            // if this is hidden slide it down
            if ($this.next().is(':hidden')) {

                // add class to this
                $this.addClass('accordionHeadingOpen');

                // add class to this
                $this.next().slideDown(function () {
                    $this.parent('.accordionContentWrap').addClass('accordionOpen');
                });

            }

        }); // .on 'click' end

    } // if length end

}); // document ready

$(window).on('resize', debouncer(function (e) {

/*
 * Force strict mode
 */

    'use strict';

/*
 * Mobile Thumbs Slideshow
 */

    if (matchesMediaQuery(0, window.breakpoints.mobile) && !$('.thumbs').hasClass('slick-initialized')) {
        thumbsSlideShow();
    } else if (matchesMediaQuery(window.breakpoints.mobile + 1) && $('.thumbs').hasClass('slick-initialized')) {
        $('.thumbs').slick('unslick');
    }

/*
 * MTC Zoom
 */

    enableZoom();

/*
 * Overlay Images on Mobile
 */

    largeImageOverlay();

})); // debounce
