/*
 * Get Images and build slider
 */

function buildLargeImageMobileSlider() {

    'use strict';

    var selector = $('.largeImage'),
        dataAttr;

    // if slick is not initialised and on mobile
    if (!selector.hasClass('slick-initialized') && matchesMediaQuery(0, window.breakpoints.mobile)) {
        // get images
        dataAttr = selector.attr('data-zoom-gallery');

        // disable zoom before reinitialising it
        if ($('.enableZoom .zoom').length) {
            $('.enableZoom').mtcZoom('destroy');
        }

        // empty large image
        selector.empty();

        // get images from thumbs and build slider from the large images
        $('.thumbs[data-zoom-gallery="' + dataAttr + '"]').find('.mtcZoomGallery').each(function () {
            var $this = $(this),
                src = $this.attr('data-large'),
                alt = $this.find('img').attr('alt'),
                title = $this.attr('title');

            selector.append('<div class="slide"><img src="' + src + '" data-zoom="' + src + '" alt="' + alt + '" title="' + title + '" /></div>');
        });

        // initialise slider
        if (selector.find('.slide').length > 1) {
            selector.slick({
                dots: true,
                arrows: false
            });
        }

    } else if (matchesMediaQuery(window.breakpoints.mobile + 1)) {
        // unslick
        if (selector.hasClass('slick-initialized')) {
            selector.slick('unslick');
        }

        /*
         * add remove all but one image
         * get images
         */
        dataAttr = selector.attr('data-zoom-gallery');

        // remove all but first image
        if (selector.find('.slide').length > 1) {
            selector.find('.slide').each(function (i) {
                var $this = $(this);
                // remove slide wrap from first image
                if (i === 0) {
                    $this.children('img').unwrap();
                }
                // remove all but first image
                if (i !== 0) {
                    $this.remove();
                }
            });
        }

        // initialise zoom
        if ($('.enableZoom .zoom').length < 1 && $('.enableZoom').length) {
            $('.enableZoom').mtcZoom({
                hideMessageOnLaunch: true
            });
        }
    }
}

$(document).ready(function () {

    'use strict';

/*
 * Item Back Button
 */

    $('.itemBackButton').on('click', function (e) {
        e.preventDefault();
        window.history.back();
    });

/*
 * Colour Linked Items Change
 */

    if ($('#colourLinkedItems').length) {

        $('body').on('change', '#colourLinkedItems', function () {
            var link = $(this).find(':selected').data('link');

            if (link !== undefined) {
                window.location.href = link;
            }
        });

    }

/*
 * Description Accordion
 */

    if ($('.accordionWrapper').length) {

        // hide all accordion content
        $('.accordionContent').hide().removeClass('accordionContentOpen');

        // show open accordion content
        $('.accordionOpen .accordionContent').show().addClass('accordionContentOpen');

        $('.accordionHeading').on('click', function () {
            var $this = $(this);

            $('.accordionContentWrap').removeClass('accordionOpen');

            // remove class form all other
            $('.accordionHeading').removeClass('accordionHeadingOpen');

            // slide up any open accordion
            $this.parents('.accordionWrapper').children().find('.accordionContent').slideUp();

            // if this is hidden slide it down
            if ($this.next().is(':hidden')) {

                // add class to this
                $this.addClass('accordionHeadingOpen');

                // add class to this
                $this.next().slideDown(function () {
                    $this.parent('.accordionContentWrap').addClass('accordionOpen');
                });

            }

        }); // .on 'click' end

    } // if length end


/*
 * Get Images and build slider
 */

    if ($('.js_itemWrap').length) {
        buildLargeImageMobileSlider();
    }

}); // document ready

$(window).on('resize', debouncer(function (e) {

/*
 * Force strict mode
 */

    'use strict';


/*
 * Get Images and build slider
 */

    if ($('.js_itemWrap').length) {
        buildLargeImageMobileSlider();
    }

})); // debounce
