<?php

namespace Mtc\Klarna\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Mtc\Checkout\Events\AddPaymentGatewayScripts;
use Mtc\Klarna\Console\Commands\InstallKlarna;
use Mtc\Klarna\Contracts\KlarnaRepositoryContract;
use Mtc\Klarna\Klarna;
use Mtc\Klarna\Listeners\AddKlarnaExternalScripts;

/**
 * Class KlarnaServiceProvider
 * @package Mtc\Klarna\Providers
 */
class KlarnaServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        if (config('klarna.enabled', false) === false) {
            return;
        }

        // Load translations
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'klarna');

        $this->app['payment']->extend('klarna', function($app) {
            return new Klarna();
        });

        if (!$this->app->runningInConsole()) {
            Event::listen(AddPaymentGatewayScripts::class, AddKlarnaExternalScripts::class);
        } else {
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
            ], 'assets');

            $this->commands([
                InstallKlarna::class,
            ]);
        }

        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
    }

    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/klarna.php', 'klarna');
        $this->app->bind(KlarnaRepositoryContract::class, config('klarna.repository_class'));
    }
}
