<?php

namespace Mtc\Klarna\Http\Controllers;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\URL;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;
use Mtc\Klarna\Contracts\KlarnaRepositoryContract;
use Mtc\Klarna\Http\Requests\AuthorizePaymentRequest;

/**
 * Class KlarnaController
 * @package Mtc\Klarna\Http\Controllers
 */
class KlarnaController
{
    /**
     * @param AuthorizePaymentRequest $request
     * @param InvoiceRepositoryContract $invoice
     * @return array|\Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\Response
     */
    public function index(AuthorizePaymentRequest $request, InvoiceRepositoryContract $invoice)
    {
        $invoice->load($request->input('invoice_id'));

        if ($invoice->isPaid()) {
            return $this->successfulPaymentResponse($invoice->getId());
        }

        $klarna_order = App::make(KlarnaRepositoryContract::class, [
            'invoice_repository' => $invoice
        ])->placeOrder($request->input('authorization_token'));

        if ($klarna_order === false) {
            return response([
                'error' => 'Invalid Order details'
            ], 422);
        }

        $invoice->savePayment([
            'provider' => 'klarna',
            'amount' => $invoice->getOutstandingAmount(),
            'amount_in_currency' => $klarna_order['original_order_amount'] / 100,
            'currency_code' => $invoice->getCurrency(),
            'reference' => $klarna_order['order_id'],
            'details' => $klarna_order,
            'confirmed_at' => config('klarna.auto_capture', false) === true ? now() : null,
        ]);

        return $this->successfulPaymentResponse($invoice->getId());
    }

    /**
     * Successful Payment Response
     *
     * @param $invoice_id
     * @return array
     */
    protected function successfulPaymentResponse($invoice_id)
    {
        return [
            'success' => true,
            'redirect' => URL::signedRoute('successful_payment', ['id' => $invoice_id ], null, config('app.env') === 'production'),
        ];
    }
}