<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Fallback git binary
    |--------------------------------------------------------------------------
    |
    | In case app isn't able to detect git binary automatically this value will
    | be used as path to git binary
    |
    */

    'fallback_git_binary' => env('GIT_BINARY', '/usr/local/cpanel/3rdparty/lib/path-bin/git'),

    /*
    |--------------------------------------------------------------------------
    | Root level modules
    |--------------------------------------------------------------------------
    |
    | Features that are allowed to be installed as root level modules (legacy)
    |
    */

    'root_modules' => [
        'cms' => 'core-cms',
        'shop' => 'core-shop',
    ],

    /*
    |--------------------------------------------------------------------------
    | Component API
    |--------------------------------------------------------------------------
    |
    | Project System API gives us lists of features available
    |
    */

    'projects_api' => [
        'endpoint' => 'https://projects.mtcmedia.co.uk/api/bitbucket/get_components',
        'api_key' => 'X9Z0AZAHFR',
    ],

    /*
    |--------------------------------------------------------------------------
    | Skippable values
    |--------------------------------------------------------------------------
    |
    | Config storing allows to skip asking some questions
    |
    */
    'skippable_values' => [
        'project_type',
        'db_host',
        'db_username',
        'db_password',
        'bb_username',
        'bb_password',
        'dev_email',
        'default_cms_setup',
    ]

];
