<?php

namespace Mtc\Installer;

/**
 * Class InstallResponse
 *
 * @package Mtc\Installer
 */
class InstallResponse
{
    /**
     * @var string
     */
    public $error;

    /**
     * @var bool
     */
    protected $succeeded;

    /**
     * Dependencies created by installation
     * @var array
     */
    protected $dependencies = [];

    /**
     * InstallResponse constructor.
     *
     * @param $succeeded
     * @param array $dependencies
     * @param string $error_message
     */
    public function __construct($succeeded, $dependencies = [], $error_message = '')
    {
        $this->succeeded = $succeeded;
        $this->dependencies = $dependencies;
        $this->error = $error_message;
    }

    /**
     * Check if install failed
     *
     * @return bool
     */
    public function failed()
    {
        return $this->succeeded == false;
    }

    /**
     * Get the list of dependencies necessary for the installed component
     *
     * @return array
     */
    public function dependencies()
    {
        return collect($this->dependencies);
    }

    /**
     * Get the error message
     *
     * @return string
     */
    public function getError()
    {
        return $this->error;
    }
}
