<?php

namespace Mtc\Installer\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;
use Mtc\Installer\Facades\Installer;

/**
 * Class InstallLegacyRootModule
 *
 * @package Mtc\Installer\Console\Commands
 */
class InstallLegacyRootModule extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'install:root-module {module}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install a root module on platform';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $module = $this->argument('module');
        $module_url = config("installer.root_modules.{$module}");

        $installed = Installer::installRootModule($module_url, $module);

        if ($installed) {
            $this->info("{$module} installed successfully");
        }

        if ($this->argument('module') === 'core') {
            Installer::addComposerAutoloadData(config('installer.injected_autoload'));
            $this->info("Autoload has been updated with core data");

        }
    }
}
