<?php

namespace Mtc\Insights;

use Exception;
use GuzzleHttp\Client;

/**
 * Class InsightApi
 *
 * @package Mtc\Insights
 */
class InsightApi
{
    /**
     * HTTP client
     *
     * @var Client
     */
    protected $client;

    /**
     * InsightApi constructor.
     *
     * @param Client $client
     */
    public function __construct(Client $client, $config)
    {
        $this->client = $client;
        $this->config = $config;
    }

    /**
     * Send data to Insight API
     *
     * @param array $data
     * @return bool
     */
    public function send($source_url, $data = [])
    {
        try {
            $response = $this->client->post($this->config['api_url'], [
                'form_params' => [
                    'from' => $source_url,
                    'data' => $data,
                    'api_key' => $this->config['api_key'],
                ]
            ]);
        } catch (Exception $exception) {
            return false;
        }

        return $response->getStatusCode() == 200;
    }
}