<?php

namespace Mtc\Insights\Tests\Unit;

use Mtc\Insights\SmartSchedule;
use Orchestra\Testbench\TestCase as OrchestraTestbench;

/**
 * Class ScheduleTest
 *
 * @package Mtc\Insights\Tests\Unit
 */
class ScheduleTest extends OrchestraTestbench
{
    /** @test */
    public function schedule_is_returned_on_call()
    {
        $schedule = $this->app->make(SmartSchedule::class)->loadSchedule();
        $this->assertIsObject($schedule);
        $this->assertObjectHasAttribute('weekday', $schedule);
        $this->assertObjectHasAttribute('time', $schedule);
    }

    /** @test */
    public function scheduler_returns_valid_weekday()
    {
        $schedule = $this->app->make(SmartSchedule::class)->loadSchedule();
        $this->assertGreaterThanOrEqual(1, $schedule->weekday);
        $this->assertLessThanOrEqual(7, $schedule->weekday);
    }

    /** @test */
    public function scheduler_returns_valid_time()
    {
        $schedule = $this->app->make(SmartSchedule::class)->loadSchedule();
        $this->assertRegExp('/[0-9]{1,2}:[0-9]{2}/', $schedule->time);
        list($hours, $minutes) = explode(':', $schedule->time);
        $this->assertGreaterThanOrEqual(0, $hours);
        $this->assertLessThanOrEqual(24, $hours);
        $this->assertGreaterThanOrEqual(0, $minutes);
        $this->assertLessThanOrEqual(60, $minutes);
    }

}
