<?php

namespace Mtc\Foundation\Rules;

use Illuminate\Contracts\Validation\Rule;

/**
 * Class ValidPhoneNumber
 *
 * @package Mtc\Foundation\Rules
 */
class ValidPhoneNumber implements Rule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return preg_match('/^\+?[0-9\- ]+$/', $value);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'This needs to be a valid phone number.';
    }
}
