<?php

namespace Mtc\Foundation\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\Core\Models\Country;

/**
 * Class CountryList
 *
 * @package Mtc\Foundation\Http\Resources
 */
class CountryList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $this->resource
            ->each(function (Country $country) {
                $country->setVisible([
                    'code',
                    'name',
                ]);

                if (config('foundation.country_list_value_fields.states')) {
                    $country->addVisible([
                        'has_states',
                        'states'
                    ]);
                }

                if (config('foundation.country_list_value_fields.counties')) {
                    $country->addVisible([
                        'has_counties',
                        'counties'
                    ]);
                }
            });
        return parent::toArray($request);
    }
}
