<!doctype html>
<html lang="en">
<head>
    @include('foundation::admin.meta')
    @yield('head')
</head>
<body data-admin="1">
<div id="vueContainer">
    <div class="vueFragment">
        <div id="dialog" class="hidden"></div>
        <div id="wrapper">

            <div id="header">

                <a href="/admin/" title="mtc." class="logo">
                    {!! file_get_contents(base_path('/core/admin/images/logo.svg')) !!}
                </a> <!-- .logo -->

                <ul class="headerTitleSection">
                    <li>
                        <span>{{ config('app.name') }}</span> Admin Dashboard
                    </li>
                </ul>

                <ul class="headerMenuSections">

                    @auth()
                    <li>
                        Welcome back, <span>{{ auth()->user()->name }}</span>
                    </li>
                    <li>
                        <a href="/admin/"
                                title="Go to {{ config('app.name') }} Admin home"
                        >
                            <i class="fa fa-home"></i>
                            Dashboard
                        </a>
                    </li>
                    <li>
                        <a href="/"
                                title="Go to {{ config('app.name') }}"
                                target="_blank"
                        >
                            <i class="fa fa-globe"></i>
                            Homepage
                        </a>
                    </li>
                    <li>
                        <i class="fa fa-sign-out"></i>
                        <a href="/admin/logout">Logout</a>
                    </li>
                    @endauth
                </ul> <!-- .headerMenuSections -->

                <a class="flyoutButton">
                    Menu<i class="fa fa-bars" aria-hidden="true"></i>
                </a>

            </div> <!-- #header -->

            <div id="content">

                @include('foundation::admin.navigation')

                <div class="rightcol">

                    @include('foundation::admin.messages')
                    @yield('content')
                </div><!-- .rightcol -->
            </div><!-- #content -->

        </div><!-- #wrapper -->

    </div>
</div>

<script type="text/javascript" src="{{ config('app.asset_prefix') . mix('/js/admin.js') }}"></script>
<script src="/core/js/jquery.tinymce.min.js"></script>
@yield('after_assets')
@routes
</body>
</html>
