<div class="sidebar">
    <admin-nav inline-template :tree="{{ \Mtc\Core\Admin\Menu::generateMenuTree(auth()->user()) }}" v-cloak>
        <ul class="topnav" v-cloak>

            <li class="siteNavigation">
            <span class="sectionHeader">
                Site Navigation
            </span>

                {% if admin_id is not empty and admin_user is not empty %}
                <ul>
                    <li>
                        <a href="/admin/"
                                title="Go to {{ config('app.name') }} Admin home"
                        >
                            <i class="fa fa-home"></i>
                            Dashboard
                        </a>
                    </li>
                    <li>
                        <a href="/"
                                title="Go to {{ config('app.name') }}"
                                target="_blank"
                        >
                            <i class="fa fa-globe"></i>
                            Homepage
                        </a>
                    </li>
                    <li>
                        <a href="/admin/logout">
                            <i class="fa fa-sign-out"></i>
                            Logout
                        </a>
                    </li>
                </ul>
                {% endif %}
            </li> <!-- .siteNavigation -->

            <li v-for="menu_item in tree"
                    :class="{
                    'open': open_sections.indexOf(menu_item.title) !== -1
                }">
                <span class="sectionHeader"
                        @click="triggerSection(menu_item.title, 'js_menuSection' + menu_item.id)">
                    <i :class="menu_item.icon" v-if="menu_item.icon != ''"></i>
                    [% menu_item.title %]
                </span>
                <ul :id="'js_menuSection' + menu_item.id">
                    <li v-for="sub_menu_item in menu_item.sub_items"
                            :class="{
                            'active' : sub_menu_item.is_active
                        }">
                        <a :href="sub_menu_item.path"
                                :target="sub_menu_item.new_window == 1 ? '_blank' : '_self'">
                            [% sub_menu_item.title %]
                        </a>
                    </li>
                </ul>
            </li>

        </ul>
    </admin-nav>
</div>