<?php

namespace Mtc\Foundation\Validators;

/**
 * Class UkPostcode
 *
 * @package Mtc\Foundation\Validators
 */
class UkPostcode
{
    /**
     * Check if postcode is valid UK postcode
     *
     * @param $postcode
     * @return false|int
     */
    public function isValid($postcode)
    {
        return preg_match(
            '/^(([Gg][Ii][Rr] 0[Aa]{2})|((([A-Za-z][0-9]{1,2})|(([A-Za-z][A-Ha-hJ-Yj-y][0-9]{1,2})|(([A-Za-z][0-9][A-Za-z])|([A-Za-z][A-Ha-hJ-Yj-y][0-9]?[A-Za-z]))))) ?[0-9][A-Za-z]{2})$/',
            $this->normalize($postcode)
        );
    }

    /**
     * Normalizes postcode format to uppercase with space.
     * Brings dd13ja to DD1 3JA
     *
     * @param $postcode_string
     *
     * @return string
     */
    public function normalize($postcode_string)
    {
        $postcode_string = strtoupper($postcode_string);

        // adjust postcode with no spaces
        if (strpos($postcode_string, ' ') === false) {
            $postcode_string = preg_replace('#(.{3})$#', ' $1', $postcode_string);
        }

        return $postcode_string;
    }

}
