<?php

namespace Mtc\Foundation\Rules;

use Carbon\Carbon;
use Illuminate\Contracts\Validation\Rule;

/**
 * Class ValidPostcode
 *
 * @package Mtc\Foundation\Rules
 */
class OptionalDMYDate implements Rule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (empty($value)) {
            return true;
        }

        try {
            Carbon::createFromFormat('d/m/Y', $value);
            return true;
        } catch (\Exception $exception) {
            return false;
        }
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return "The provided date must be valid";
    }
}
