<?php

namespace Mtc\Foundation\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Foundation\Providers\FoundationServiceProvider;
use Mtc\Stripe\Providers\StripeServiceProvider;

/**
 * Class InstallFoundation
 *
 * @package Mtc\Foundation
 */
class InstallFoundation extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'install:foundation';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install Foundation assets';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $this->info('Installing Foundation assets');

        $this->callSilent('vendor:publish', [
            '--provider' => FoundationServiceProvider::class,
            '--tag' => 'assets',
        ]);

        $this->info('Foundation assets installed successfully.');
    }
}
