<?php

namespace Mtc\Foundation;

/**
 * Class Manager
 *
 * @package Mtc\Foundation
 */
abstract class Manager extends \Illuminate\Support\Manager
{
    /**
     * Register a new driver for the manager
     *
     * @param $name
     * @param \Closure $callback
     */
    public function register($name, \Closure $callback)
    {
        $this->app[static::getManagerName()]->extend($name, $callback);
    }

    /**
     * Get the default driver name.
     *
     * @return string
     */
    public function getDefaultDriver()
    {
        return $this->app['config'][static::getDriverConfigName()];
    }

    /**
     * Build up drivers that are not yet created
     *
     * @return void
     */
    protected function createMissingDrivers()
    {
        collect(array_diff(array_keys($this->customCreators), array_keys($this->drivers)))
            ->each(function ($driver) {
                $this->driver($driver);
            });
    }

    /**
     * Set the default session driver name.
     *
     * @param  string  $name
     * @return self
     */
    public function setActiveDriver($name)
    {
        $this->app['config'][static::getDriverConfigName()] = $name;
        return $this;
    }

    /**
     * Define the name of the config driver will use to set the active driver
     *
     * @return string
     */
    abstract public function getDriverConfigName(): string;

    /**
     * Manager Name registered (i.e. facade accessor)
     *
     * @return string
     */
    abstract public function getManagerName(): string;
}
