<?php

namespace Mtc\Foundation\Filters;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Mtc\Foundation\Contracts\AdminFilter;

/**
 * Class FilterByMemberId
 *
 * @package Mtc\Foundation\Filters
 */
class FilterByMemberId implements AdminFilter
{
    /**
     * Constant for input field name
     */
    public const INPUT_FIELD_NAME = 'member_id';

    /**
     * Field definition
     *
     * @return mixed
     */
    public function field()
    {
        return [
            'type' => 'text',
            'name' => self::INPUT_FIELD_NAME,
            'label' => 'Member ID',
            'value' => \request(self::INPUT_FIELD_NAME),
        ];
    }

    /**
     * Handle the filtering of a field
     *
     * @param Request $request
     * @param Builder $query
     * @return Builder
     */
    public function handle(Request $request, Builder $query): Builder
    {
        if (empty($request->input(self::INPUT_FIELD_NAME))) {
            return $query;
        }

        return $query->where('member_id', $request->input(self::INPUT_FIELD_NAME));
    }
}
