<?php

namespace Mtc\Foundation\Filters;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Mtc\Foundation\Contracts\AdminFilter;

/**
 * Class FilterByEmail
 *
 * @package Mtc\Orders\Filters
 */
class FilterByEmail implements AdminFilter
{
    /**
     * Constant for input field name
     */
    public const INPUT_FIELD_NAME = 'email';

    /**
     * Field definition
     *
     * @return mixed
     */
    public function field()
    {
        return [
            'type' => 'text',
            'name' => self::INPUT_FIELD_NAME,
            'label' => 'Email',
            'value' => \request(self::INPUT_FIELD_NAME),
        ];
    }

    /**
     * Handle the filtering of a field
     *
     * @param Request $request
     * @param Builder $query
     * @return Builder
     */
    public function handle(Request $request, Builder $query): Builder
    {
        if (empty($request->input(self::INPUT_FIELD_NAME))) {
            return $query;
        }

        // Full match will be a lot quicker due to use of index which is not possible with wild-card in front
        if (filter_var($request->input(self::INPUT_FIELD_NAME), FILTER_VALIDATE_EMAIL)) {
            return $query->where('email', $request->input(self::INPUT_FIELD_NAME));
        }

        // Partial match
        return $query->where('email', 'like', '%' . $request->input(self::INPUT_FIELD_NAME) . '%');
    }
}
