<?php

namespace Mtc\Foundation\Contracts;

/**
 * Interface InstallableComponent
 *
 * This interface
 *
 * @package Mtc\Foundation
 */
interface InstallableComponent
{
    /**
     * Define what needs to be published.
     * This should be formatted in following format:
     * [
     *      [
     *          '--provider' => ProviderClassName::class,
     *          '--tag' => 'assets'
     *      ]
     * ]
     * @return array
     */
    public function publish(): array;

    /**
     * Provide a classname of seeder that should be called
     * In case of no seed required provide an empty string
     *
     * @return string
     */
    public function seed(): string;

    /**
     * List of npm packages and their version restrictions
     * [
     *      'collect.js' => "^4.6.2"
     * ]
     * @return array
     */
    public function npmDependencies(): array;

    /**
     * Whether npm should be run to compile assets after installation has been done
     *
     * @return bool
     */
    public function shouldRunNpm(): bool;
}
