<?php

namespace Mtc\Filter\Seo;

use Mtc\Core\Seo\Page;
use Mtc\Filter\Contracts\FilterInstance;
use Mtc\Filter\Contracts\SeoMatchingMechanism;
use Mtc\Shop\Category;

class MatchSelectedCategory implements SeoMatchingMechanism
{
    /**
     * Perform a check if this mechanism should be used for setting up SEO
     * data for the page
     *
     * @param FilterInstance $filter
     * @return bool
     */
    public function matchesRequest(FilterInstance $filter): bool
    {
        return Page::query()
            ->where('path', $filter->getPageUrl())
            ->exists();
    }

    /**
     * Obtain SEO data for given filter object/page
     *
     * @param FilterInstance $filter
     * @return array
     */
    public function getData(FilterInstance $filter): array
    {
        $total_count = count($filter->getSelections('category'));
        if ($total_count < config('settings.MAX_CATEGORY_DEPTH') && $total_count > 0) { //maximum of six levels assumed
            //figure out if the selected cats are a path
            $selected_cats = Category::query()
                ->whereIn('id', $filter->getSelections('category'))
                ->pluck('id')
                ->toArray();

            $bottom_cat_id = array_diff($filter->getSelections('category'), $selected_cats);
            if (count($bottom_cat_id) != 1) {
                return [];
            }

            $bottom_cat_id = end($bottom_cat_id);

            $category_data = Category::query()
                ->select([
                    'seo_title AS title',
                    'seo_description AS description'
                ])
                ->where('id', $bottom_cat_id)
                ->where(function ($query) {
                    return $query->where('seo_title', '!=', '')
                        ->orWhere('seo_description', '!=', '');
                })
                ->first();

            if ($category_data) {
                return $category_data->toArray();
            }
        }
        return $category_data ? $category_data->only(['title', 'description']) : [];
    }
}
