// noinspection JSVoidFunctionReturnValueUsed

import store from '../../store';

store.registerModule('productFilter', {
    state: {
        filter_items: [],
        filters: {},
        pagination: [],
        selections: [],
        selection_details: [],
        expanded: [],
        sort_options: [],
        sort_by: '',
        seo: {},
        url: '',
        base_url: '',
        page: 1,
    },
    getters: {
        selections: state => {
            return state.selections
        }
    },
    mutations: {
        setBaseUrl(state, base_url) {
            state.base_url = base_url;
        },
        initFilter(state) {
            state.filter_items = window.filterData.results.data;
            state.pagination = window.filterData.results;
            state.filters = window.filterData.filters;
            state.selection_details = window.filterData.selections;
            state.sort_options = window.filterData.sort_options;
            state.seo = window.filterData.seo;
            state.url = window.filterData.url;
        },
        load(state, expand = null) {
            if (expand) {
                state.expanded.push(expand)
            }

            Vue.http.post(state.base_url, {
                selections: state.selections,
                page: state.page,
                sort_by: state.sort_by,
                expanded: state.expanded
            })
                .then(function (response) {
                    state.filter_items = response.data.results.data;
                    state.pagination = response.data.results;
                    state.filters = response.data.filters;
                    state.selection_details = response.data.selections;
                    state.sort_options = response.data.sort_options;
                    state.seo = response.data.seo;
                    state.url = response.data.url;
                    state.selections = state.selections;

                    if (expand !== null) {
                        return;
                    }
                    // Push state to history to set url update and navigation back
                    try {
                        document.title = response.data.seo.title;
                        window.history.pushState(
                            {
                                'pageTitle': response.data.seo.title,
                                'state_content': state
                            },
                            '',
                            response.data.url
                        );
                    } catch (ex) {
                        window.location.href = response.data.url;
                    }
                });
        },
        setState(state, state_data) {
            state.filter_items = state_data.filter_items;
            state.pagination = state_data.pagination;
            state.filters = state_data.filters;
            state.selection_details = state_data.selection_details;
            state.sort_options = state_data.sort_options;
            state.seo = state_data.seo;
            state.url = state_data.url;
            state.selections = state_data.selections;
        },
        setAllSelections(state, selections) {
            state.selections = selections;
        },
        setSelection(state, data) {
            let index = state.selections.findIndex((selection) => selection.type === data.type);
            if (index !== -1) {
                state.selections.splice(index, 1);
            }
            state.selections.push(data);
        },
        setFilterPage(state, page) {
            state.page = page;
        },
        setSortOption(state, sortOption) {
            state.sort_by = sortOption;
        },
        addSelection(state, entryToAdd) {
            let exists = state.selections
                .filter(entry => entry.value === entryToAdd.value && entry.type === entryToAdd.type)
                .length > 0;

            if (exists === false) {
                state.selections.push(entryToAdd);
            }
        },
        removeSelection(state, entryToRemove) {
            let index = state.selections.findIndex(entry => entry.value === entryToRemove.value && entry.type === entryToRemove.type);

            if (index !== -1) {
                state.selections.splice(index, 1);
            }
        }
    },
    actions: {
        setFilterSelections(context, selections) {
            context.commit('setAllSelections', selections);
        },
        setSortOption(context, sortOption) {
            context.commit('setSortOption', sortOption)
        },
        loadFilter(context, base_url) {
            if (base_url !== undefined) {
                context.commit('setBaseUrl', base_url);
            }
            context.commit('load');
        },
        initFilter(context, base_url) {
            if (base_url !== undefined) {
                context.commit('setBaseUrl', base_url);
            }
            context.commit('initFilter');
        },
        addFilterSelection(context, data) {
            context.commit('addSelection', data);
            context.commit('setFilterPage', 1);
            context.commit('load');
        },
        setFilterSelection(context, data) {
            context.commit('setSelection', data);
            context.commit('setFilterPage', 1);
            context.commit('load');
        },
        setFilterState(context, state) {
            context.commit('setState', state);
        },
        removeFilterSelection(context, data) {
            context.commit('removeSelection', data);
            context.commit('setFilterPage', 1);
            context.commit('load');
        },
        removeFilterSelections(context, data) {
            data.forEach((entry) => entry && context.commit('removeSelection', entry));
            context.commit('load');
        },
        setFilterPage(context, page) {
            context.commit('setFilterPage', page);
        },
        showMoreFilterChoices(context, expandSection) {
            context.commit('load', expandSection);
        }
    }
});
