<?php

namespace Mtc\Filter\Tests\Unit;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Mtc\Filter\Filter;
use Mtc\Filter\Tests\TestCase;

class FilterTest extends TestCase
{
    public function testGetFilters()
    {
        /** @var Filter $filter */
        $filter = App::make(Filter::class);

        $filters = collect([
            'category' => App::make(\Mtc\Filter\Filters\CategoryFilter::class),
            'brand' => App::make(\Mtc\Filter\Filters\BrandFilter::class),
            'size' => App::make(\Mtc\Filter\Filters\SizeFilter::class),
            'colour' => App::make(\Mtc\Filter\Filters\ColourFilter::class),
            'price' => App::make(\Mtc\Filter\Filters\PriceFilter::class),
            'search' => App::make(\Mtc\Filter\Filters\SearchTermFilter::class),
        ]);

        $this->assertEquals($filters, $filter->getFilters());
    }

    public function testGetCustomFilters()
    {
        /** @var Filter $filter */
        $filter = App::make(Filter::class);

        $filters = collect([
            'price' => App::make(\Mtc\Filter\Filters\PriceFilter::class),
            'search' => App::make(\Mtc\Filter\Filters\SearchTermFilter::class),
        ]);

        $this->assertEquals($filters, $filter->getCustomPatternFilters());
    }


    public function testGetSelections()
    {
        /** @var Filter $filter */
        $filter = App::make(Filter::class);
        $this->assertEquals([], $filter->getSelections());
    }

    public function testGetCurrentPage()
    {
        /** @var Filter $filter */
        $filter = App::make(Filter::class);
        $this->assertEquals(1, $filter->getCurrentPage());

        $request = App::make(Request::class);
        $request->merge(['page' => 3]);
        $filter = App::make(Filter::class);
        $this->assertEquals(3, $filter->getCurrentPage());
    }

}