# Filters

Detailed information about requirements and features of the filter

## IsFilter

All filters must implement `Mtc\Filter\Contracts\IsFilter` abstract class.
This class by itself does provide some default values that can be overwritten 
within your class if it is required.

`IsFilter` does define following methods as abstract and these need to be specified 
for each filter:
```php
    /**
     * Apply selection(s) to current filtered object
     */
    abstract public function applyFilter($query, array $selection = []);

    /**
     * Get available results of this filter type
     */
    abstract public function getResults(Closure $product_filtering, int $limit, array $selections = []): Collection;

    /**
     * Specify model that drives this filter option.
     * Used to build up filter index.
     */
    abstract public function getModel(): string;

    /**
     * Customer facing name of the filter
     */
    abstract public function title(): string;

    /**
     * Specify how a slug is formed for this object
     */
    abstract public function modelSlug(Model $model): string;
```

## IsCustomFieldFilter

When building a filter for a custom field things can be simplified as they follow the same pattern
and most of the `IsFilter` methods can be hidden as they will not be required. Due to this
`Mtc\Filter\Contracts\IsCustomFieldFilter` class has been created

As a result `IsCustomFieldFilter` does define following methods as required by the class
that extends it:
```php
    /**
     * Customer facing name of the filter
     */
    abstract public function title(): string;

    /**
     * Get the field column/db_name name
     */
    abstract public function getFieldColumnName(): string;

    /**
     * Is this custom field stored in custom_multiple format
     */
    abstract public function isMultiple(): bool;
```

## CustomPatternFilter

`IsFilter` class by itself assumes that there is a unique model value that is the selected value (category, brand, size).
However, there are situations when this is not the case and the pattern is defined differently - e.g. price range, search term.
To implement this pattern `Mtc\Filter\Contracts\CustomPatternFilter` is available. If the filter does not have a model value
for selection this interface should be implemented on the filter definition.

`CustomPatternFilter` adds 3 methods to the filter definition:
```php
    /**
     * Check if $selection (url slug) matches pattern on this filter
     */
    public function patternMatched(string $selection): bool;

    /**
     * Decode $selection url slug to selection value(s)
     *
     * @param string $selection
     * @return string|array
     */
    public function matchSelections(string $selection);

    /**
     * Create URL slug for $selection value
     *
     * @param $selection
     * @return string
     */
    public function createSlug($selection): string;
```


## UI component

By default `checkbox-filter` component will be used for filters unless specified otherwise.
The component can be changed to a different one by adding following method to your filter definition:
```php
public function uiComponentType(): string
```